KPL/FK

\beginlabel
PDS_VERSION_ID               = PDS3
RECORD_TYPE                  = STREAM
RECORD_BYTES                 = "N/A"
^SPICE_KERNEL                = "mer1_v11.tf"
MISSION_NAME                 = "MARS EXPLORATION ROVER"
SPACECRAFT_NAME              = "MARS EXPLORATION ROVER 1"
DATA_SET_ID                  = "MER1-M-SPICE-6-V1.0"
KERNEL_TYPE_ID               = FK
PRODUCT_ID                   = "mer1_v11.tf"
PRODUCT_CREATION_TIME        = 2016-06-17T09:51:01
PRODUCER_ID                  = "NAIF/JPL"
MISSION_PHASE_NAME           = "N/A"
PRODUCT_VERSION_TYPE         = ACTUAL
PLATFORM_OR_MOUNTING_NAME    = "N/A"
START_TIME                   = "N/A"
STOP_TIME                    = "N/A"
SPACECRAFT_CLOCK_START_COUNT = "N/A"
SPACECRAFT_CLOCK_STOP_COUNT  = "N/A"
TARGET_NAME                  = MARS
INSTRUMENT_NAME              = "N/A"
NAIF_INSTRUMENT_ID           = "N/A"
SOURCE_PRODUCT_ID            = "N/A"
NOTE                         = "See comments in the file for details"
OBJECT                       = SPICE_KERNEL
  INTERCHANGE_FORMAT         = ASCII
  KERNEL_TYPE                = FRAMES
  DESCRIPTION                = "Frames kernel containing a complete set of
frame definitions for the local frames, rover frames, appendage/manipulator
frames, and science instrument frames. "
END_OBJECT                   = SPICE_KERNEL
\endlabel


MER-1 Frames Kernel -- FLIGHT PARAMETERS
========================================================================

   This frame kernel contains complete set of frame definitions for the
   MER-1 including definitions for the MER-1 cruise, lander, and rover
   frames, local level, topocentric and surface-fixed frames, IDD, PMA
   and mobility structure frames, and science instrument frames.


Version and Date
========================================================================

   Version 1.1 -- March 30, 2016 -- Boris Semenov, NAIF

      Added NAID<->ID mappings for sites 200-299.

   Version 1.0 -- July 2, 2008 -- Boris Semenov, NAIF

      Added MER-1_EDL_MME frame.

   Version 0.9 -- September 21, 2004 -- Boris Semenov, NAIF

      Added NAID<->ID mappings for sites 100-199.

   Version 0.8 -- July 8, 2004 -- Boris Semenov, NAIF

      Added HGA_BORESIGHT frame to incorporate 0.45 deg offset angle
      of the actual HGA boresight. Corrected HGA frame description.

   Version 0.7 -- February 6, 2004 -- Boris Semenov, NAIF

      Updated the "TOPO" frame orientation based on the official
      landing site location determined by MER NAV Team and delivered in
      Rover Position File (RPF) "rpf_b_040128_0950_dte+ody.txt".

   Version 0.6 -- February 4, 2004 -- Boris Semenov, NAIF

      Re-classified IDD_TURRET_HEAD frame as CK-based frame to allow
      storing its deflected orientation directly w.r.t. to the ROVER
      frame.

   Version 0.5 -- January 25, 2004 -- Boris Semenov, NAIF

      Incorporated actual camera offsets based on the latest camera
      models.

   Version 0.4 -- December 10, 2003 -- Boris Semenov, NAIF

      Added HGA_ZERO_EL frame to allow storing HGA gimbal rotations in
      separate CK segments.

   Version 0.3 -- December 4, 2003 -- Boris Semenov, NAIF

      Replaced PANCAM_LEFT and PANCAM_RIGHT frames each with 
      eight individual frames, one for every filter.

      Replaced MICROIMAGER frame with two frames, one for closed and 
      one for open cover (called MICROIMAGER_F1 and MICROIMAGER_F2)

      Re-defined PMA_BASE frame to be CK-based (to allow separate CK
      segments for PMA AZ and EL rotations.)

      Added PMA_ZERO_AZ and PMA_ZERO_EL frames to allow incorporating 
      the gimbal angle corrections into the PMA frame chain.

   Version 0.2 -- September 29, 2003 -- Boris Semenov, NAIF

      Migrated the "TOPO" frame definition from a separate file --
      mer1_tp_tm20b3_iau2000_v1.tf -- to this file as the final landing
      site selection has been made.

      Modified NAVCAM, PANCAM and HAZCAM frame definitions to match 
      preliminary calibration data (CAHVOR(E) models.) Note that 
      the calibration update is expected in Aug-Sep '03.

      Declared IDD_BASE frame obsolete as IDD engineers ended up not
      using it for anything; modified tables and diagrams to reflect
      that. 

      Corrected IDD diagrams to reflect actual relative location of the
      joints.

      Replaced nominal IDD instrument offset values with the actual
      values from calibration report.

      Changed the following HAZCAM frame and structure name to be consistent
      with MIPS terminology:

         HAZCAM_FRONT_LEFT  --> FRONT_HAZCAM_LEFT  
         HAZCAM_FRONT_RIGHT --> FRONT_HAZCAM_RIGHT
         HAZCAM_REAR_LEFT   --> REAR_HAZCAM_LEFT  
         HAZCAM_REAR_RIGHT  --> REAR_HAZCAM_RIGHT

      Changed MINI_TES to MINITES for the same reason.

      Corrected diagrams to place shown ROVER frame origin closer to the 
      to the actual Rover Navigation Frame origin location, to put MINITES 
      off-center w.r.t. to the PMA AZ axis, and to put PMA head frame
      center closer to the left side of the PMA assembly.

      Change rotation order and angle values of the Euler angles
      specifying orientation of the cameras w.r.t. to their reference 
      frames. Now to rotate from reference to camera it is first about 
      Y, second about X, third about Z. Updated comments to reflect this.

      Added name-ID mappings for individual SITEs (SITE_##/-2539##.)

   Version 0.1 -- March 28, 2003 -- Boris Semenov, NAIF

      Fixed NAVCAM/PANCAM LEFT/RIGHT ID codes in the frame definitions
      and body ID-name mapping keywords. NAVCAM LEFT/RIGHT IDs are now
      -253111/-253112; PANCAM LEFT/RIGHT IDs are -253121/-253122. 

      Fixed NAVCAM/PANCAM LEFT/RIGHT frame ASCII diagrams to show the
      right hand frames.

      Fixed PANCAM LEFT/RIGHT frame definitions to make nominal toe-in
      rotations in the right direction.
 
   Version 0.0 -- February 13, 2003 -- Boris Semenov, NAIF

      MER-B was replaced with MER-1 to match projects official
      name<->id mapping.
 
   Version 0.0 -- October 18, 2002 -- Boris Semenov, NAIF

      Initial Release. Complete frame layout, but some descriptions and 
      diagram are not implemented.
 

References
========================================================================

   1. ``Frames Required Reading''

   2. ``Kernel Pool Required Reading''

   3. ``C-Kernel Required Reading''

   4. ``MER Pointing, Positioning, Phasing and Coordinate Systems'', 
      MER420-2-431, Latest Version

   5. MAS, IDD, HGA, and PMA MICD documents, MER420-3-480, Latest 
      Version

   6. FM IDD Test Report Summary, Eric T. Baumgartner, March 2003.

   7. Blanchard, Robert C., ``Entry Descent and Landing Trajectory and
      Atmosphere Reconstruction for the Mars Exploration Rover Missions
      A and B'', April 25, 2008, The George Washington University, 
      Performed under NASA-JPL subcontract CCNS20568F.


Contact Information
========================================================================

   Boris V. Semenov, NAIF/JPL, (818)-354-8136, bsemenov@spice.jpl.nasa.gov


Implementation Notes
========================================================================

   This file is used by the SPICE system as follows: programs that make
   use of this frame kernel must `load' the kernel, normally during
   program initialization. The SPICELIB routine FURNSH and CSPICE
   function furnsh_c load a kernel file into the kernel pool as shown
   below.

      CALL FURNSH ( 'frame_kernel_name' )
      furnsh_c    ( 'frame_kernel_name' )

   This file was created and may be updated with a text editor or word
   processor.


MER-1 NAIF ID Codes
========================================================================

   The following names and NAIF ID codes are assigned to the MER-1
   rover, its structures and science instruments (the keywords
   implementing these definitions are located in the section "MER-1
   Mission NAIF ID Codes -- Definition Section" at the end of this
   file):
 
   MER-1 rover, landing site, and sites:
   -------------------------------------

      MER-1                      -253
      MER-1_LANDING_SITE         -253900
      MER-1_SITE_###             -253###, 

         where:   ### = 900 +  site#       for sites   1...99 
                  ### = 800 + (site#-100)  for sites 100..199
                  ### = 700 + (site#-200)  for sites 200..299

   MER-1 HAZCAMs:
   --------------

      MER-1_FRONT_HAZCAM_LEFT    -253011
      MER-1_FRONT_HAZCAM_RIGHT   -253012
      MER-1_REAR_HAZCAM_LEFT     -253021
      MER-1_REAR_HAZCAM_RIGHT    -253022

   MER-1 PMA structures and PMA-mounted instruments:
   --------------------------------------------------

      MER-1_PMA_BASE             -253100
      MER-1_PMA_HEAD             -253110
      MER-1_NAVCAM_LEFT          -253111
      MER-1_NAVCAM_RIGHT         -253112
      MER-1_PANCAM_LEFT_F1       -253121
      MER-1_PANCAM_LEFT_F2       -253122
      MER-1_PANCAM_LEFT_F3       -253123
      MER-1_PANCAM_LEFT_F4       -253124
      MER-1_PANCAM_LEFT_F5       -253125
      MER-1_PANCAM_LEFT_F6       -253126
      MER-1_PANCAM_LEFT_F7       -253127
      MER-1_PANCAM_LEFT_F8       -253128
      MER-1_PANCAM_RIGHT_F1      -253131
      MER-1_PANCAM_RIGHT_F2      -253132
      MER-1_PANCAM_RIGHT_F3      -253133
      MER-1_PANCAM_RIGHT_F4      -253134
      MER-1_PANCAM_RIGHT_F5      -253135
      MER-1_PANCAM_RIGHT_F6      -253136
      MER-1_PANCAM_RIGHT_F7      -253137
      MER-1_PANCAM_RIGHT_F8      -253138
      MER-1_MINITES              -253140

   MER-1 IDD structures and IDD-mounted instruments:
   --------------------------------------------------

      MER-1_IDD_BASE             -253200
      MER-1_IDD_SHOULDER_AZ      -253201
      MER-1_IDD_SHOULDER_EL      -253202
      MER-1_IDD_ELBOW            -253203
      MER-1_IDD_WRIST            -253204
      MER-1_IDD_TURRET           -253205
      MER-1_IDD_TURRET_HEAD      -253206
      MER-1_APXS                 -253210
      MER-1_MICROIMAGER          -253220
      MER-1_MICROIMAGER_F1       -253221
      MER-1_MICROIMAGER_F2       -253222
      MER-1_RAT                  -253230
      MER-1_MOSSBAUER            -253240

   MER-1 Antennas:
   ---------------

      MER-1_MGA                  -253500
      MER-1_CLGA                 -253510
      MER-1_BLGA                 -253520      
      MER-1_UHF                  -253030
      MER-1_HGA_BASE             -253300
      MER-1_HGA                  -253310
      MER-1_RLGA                 -253540

   MER-1 mobility system components:
   ---------------------------------

      MER-1_ROCKER_LEFT          -253410
      MER-1_BOGEY_LEFT           -253411
      MER-1_STRUT_FRONT_LEFT     -253412
      MER-1_STRUT_REAR_LEFT      -253413
      MER-1_ROCKER_RIGHT         -253420
      MER-1_BOGEY_RIGHT          -253421
      MER-1_STRUT_FRONT_RIGHT    -253422
      MER-1_STRUT_REAR_RIGHT     -253423


MER-1 Frames
========================================================================

   The following MER-1 frames are defined in this kernel file:

           Name                      Relative to         Type    NAIF ID
      ======================     ===================     =====   =======

   MER-1 EDL frames:
   ---------------------

      MER-1_EDL_MME              J2000                   FIXED   -253930

   MER-1 Surface frames:
   ---------------------

      MER-1_TOPO                 IAU_MARS                FIXED   -253900
      MER-1_LOCAL_LEVEL          MER-1_TOPO              FIXED   -253910
      MER-1_SURFACE_FIXED        MER-1_LOCAL_LEVEL       FIXED   -253920

   MER-1 rover, lander, and cruise frames:
   ---------------------------------------

      MER-1_ROVER                MER-1_LOCAL_LEVEL       CK      -253000
      MER-1_LANDER               MER-1_LOCAL_LEVEL       FIXED   -253700
      MER-1_CRUISE               J2000                   CK      -253800

   MER-1 rover body-mounted instrument frames:
   -------------------------------------------

      MER-1_FRONT_HAZCAM_LEFT    MER-1_ROVER             FIXED   -253011
      MER-1_FRONT_HAZCAM_RIGHT   MER-1_ROVER             FIXED   -253012
      MER-1_REAR_HAZCAM_LEFT     MER-1_ROVER             FIXED   -253021
      MER-1_REAR_HAZCAM_RIGHT    MER-1_ROVER             FIXED   -253022
      MER-1_UHF                  MER-1_ROVER             FIXED   -253030

   MER-1 PMA and PMA-mounted instrument frames:
   --------------------------------------------
  
      MER-1_PMA_ZERO_AZ          MER-1_ROVER             CK      -253101
      MER-1_PMA_BASE             MER-1_PMA_ZERO_AZ       CK      -253100
      MER-1_PMA_ZERO_EL          MER-1_BASE              CK      -253102
      MER-1_PMA_HEAD             MER-1_PMA_ZERO_EL       CK      -253110
      MER-1_NAVCAM_LEFT          MER-1_PMA_HEAD          FIXED   -253111
      MER-1_NAVCAM_RIGHT         MER-1_PMA_HEAD          FIXED   -253112
      MER-1_PANCAM_LEFT_F1       MER-1_PMA_HEAD          FIXED   -253121
      MER-1_PANCAM_LEFT_F2       MER-1_PMA_HEAD          FIXED   -253122
      MER-1_PANCAM_LEFT_F3       MER-1_PMA_HEAD          FIXED   -253123
      MER-1_PANCAM_LEFT_F4       MER-1_PMA_HEAD          FIXED   -253124
      MER-1_PANCAM_LEFT_F5       MER-1_PMA_HEAD          FIXED   -253125
      MER-1_PANCAM_LEFT_F6       MER-1_PMA_HEAD          FIXED   -253126
      MER-1_PANCAM_LEFT_F7       MER-1_PMA_HEAD          FIXED   -253127
      MER-1_PANCAM_LEFT_F8       MER-1_PMA_HEAD          FIXED   -253128
      MER-1_PANCAM_RIGHT_F1      MER-1_PMA_HEAD          FIXED   -253131
      MER-1_PANCAM_RIGHT_F2      MER-1_PMA_HEAD          FIXED   -253132
      MER-1_PANCAM_RIGHT_F3      MER-1_PMA_HEAD          FIXED   -253133
      MER-1_PANCAM_RIGHT_F4      MER-1_PMA_HEAD          FIXED   -253134
      MER-1_PANCAM_RIGHT_F5      MER-1_PMA_HEAD          FIXED   -253135
      MER-1_PANCAM_RIGHT_F6      MER-1_PMA_HEAD          FIXED   -253136
      MER-1_PANCAM_RIGHT_F7      MER-1_PMA_HEAD          FIXED   -253137
      MER-1_PANCAM_RIGHT_F8      MER-1_PMA_HEAD          FIXED   -253138
      MER-1_MINITES              MER-1_PMA_HEAD          FIXED   -253140

   MER-1 IDD and IDD-mounted instrument frames:
   --------------------------------------------

      MER-1_IDD_BASE             MER-1_ROVER             FIXED   -253200
      MER-1_IDD_SHOULDER_AZ      MER-1_ROVER             CK      -253201
      MER-1_IDD_SHOULDER_EL      MER-1_IDD_SHOULDER_AZ   CK      -253202
      MER-1_IDD_ELBOW            MER-1_IDD_SHOULDER_EL   CK      -253203
      MER-1_IDD_WRIST            MER-1_IDD_ELBOW         CK      -253204
      MER-1_IDD_TURRET           MER-1_IDD_WRIST         CK      -253205
      MER-1_IDD_TURRET_HEAD      MER-1_IDD_TURRET        CK      -253206
      MER-1_APXS                 MER-1_IDD_TURRET_HEAD   FIXED   -253210
      MER-1_MICROIMAGER_F1       MER-1_IDD_TURRET_HEAD   FIXED   -253221
      MER-1_MICROIMAGER_F2       MER-1_IDD_TURRET_HEAD   FIXED   -253222
      MER-1_RAT                  MER-1_IDD_TURRET_HEAD   FIXED   -253230
      MER-1_MOSSBAUER            MER-1_IDD_TURRET_HEAD   FIXED   -253240

   MER-1 antenna frames:
   ----------------------

      MER-1_MGA                  MER-1_ROVER             FIXED   -253500
      MER-1_CLGA                 MER-1_ROVER             FIXED   -253510
      MER-1_BLGA                 MER-1_ROVER             FIXED   -253520      
      MER-1_UHF                  MER-1_ROVER             FIXED   -253030
      MER-1_HGA_BASE             MER-1_ROVER             FIXED   -253300
      MER-1_HGA_ZERO_EL          MER-1_HGA_BASE          CK      -253301
      MER-1_HGA                  MER-1_HGA_ZERO_EL       CK      -253310
      MER-1_HGA_BORESIGHT        MER-1_HGA               FIXED   -253311
      MER-1_RLGA                 MER-1_ROVER             FIXED   -253540

   MER-1 mobility system frames:
   -----------------------------

      MER-1_ROCKER_LEFT          MER-1_ROVER             CK      -253410
      MER-1_BOGEY_LEFT           MER-1_ROCKER_LEFT       CK      -253411
      MER-1_STRUT_FRONT_LEFT     MER-1_ROCKER_LEFT       CK      -253412
      MER-1_STRUT_REAR_LEFT      MER-1_BOGEY_LEFT        CK      -253413
      MER-1_ROCKER_RIGHT         MER-1_ROVER             CK      -253420
      MER-1_BOGEY_RIGHT          MER-1_ROCKER_RIGHT      CK      -253421
      MER-1_STRUT_FRONT_RIGHT    MER-1_ROCKER_RIGHT      CK      -253422
      MER-1_STRUT_REAR_RIGHT     MER-1_BOGEY_RIGHT       CK      -253423


MER-1 Frame Tree
========================================================================

   The diagram below shows the MER-1 frame hierarchy:


                                   "J2000" 
          +-------------------------------------------------------+
          |                           |             |             |
          |<-ck                       |<-pck        |<-fixed      |<-pck
          |                           |             |             |
          v                           v             V             v
      MER-1_CRUISE               "IAU_MARS" "MER-1_EDL_MME" "IAU_EARTH"
      -----------------          ---------- --------------- -----------
          ^      .                    |             
          .      .                    |<-fixed      
          .      .                    |             
          .      .                    v             
          .      .               "MER-1_TOPO"  
          .      .               ------------
          .      .                    |            
          .      .                    |<-fixed     
          .      .                    |            
          .      .                    v    
          .      .            "MER-1_LOCAL_LEVEL"  
          .      .            ------------------------------------+   
          .      .                    |             |             |
          .      .                    |<-ck         |<-fixed      |<-fixed
          .      .                    |             |             |
          .      .                    |             v             v
          .      .                    |  "MER-1_SURFACE_FIXED" "MER-1_LANDER" 
          .      .                    |  --------------------- -------------- 
          .      .     (3)            |                           ^
          .      . . . .. . . ..      |                           .
          .      .      .      .      |                           .
          .      .      .      .      |                           .
          .      v      .      .      |                           .
          . "MER-1_CLGA".      .      |              "MER-1_RLGA" .
          . ------------.      .      |              ------------ .
          .      ^      .      .      |                    ^      .
          .      |      .      .      |                    |      .
          .      |<-fxd .      .      |                    |<-fxd .
          .      |      .      .      |                    |      .
          .      |      v      .      |                    |      .
          .      | "MER-1_BLGA".      |   "MER-1_HAZCAM_*" |      . 
          .      | ------------.      |   ---------------- |      .
          .      |      ^      .      |             ^      |      .
          .      |      |      .      |             |      |      .
          .      |      |<-fxd .      |             |<-fxd |      .
          .      |      |      .      |             |      |      .
          .      |      |      v      |             |      |      .
          .      |      | "MER-1_MGA" | "MER-1_UHF" |      |      .
          .      |      | ----------- | ----------- |      |      .
          .      |      |      ^      |      ^      |      |      .
          .      |      |      |      |      |      |      |      .
          .(1)   |      | fxd->|      |      |<-fxd |      |      .(2)
          .      |      |      |      |      |      |      |      .
          v      |      |      |      v      |      |      |      v
          +-------------------------------------------------------+
                                "MER-1_ROVER"
          +-------------------------------------------------------+
          |             |                           |             |
          |             |<-fixed                    |<-fixed      |
          |             |                           |             |
          |             v                           v             |
          |     "MER-1_PMA_ZERO_AZ"           "MER-1_HGA_BASE"    |
          |     -------------------           ----------------    |
          |             |                           |             |
          |             |<-ck                       |<-ck         |
          |             |                           |             |
          |             V                           v             |
          |      "MER-1_PMA_BASE"           "MER-1_HGA_ZERO_EL"   |
          |      ----------------           -------------------   |
          |             |                           |             |
          |             |<-fixed                    |<-ck         |
          |             |                           |             |
          |             V                           V             |
          |     "MER-1_PMA_ZERO_EL"             "MER-1_HGA"       |
          |     -------------------             -----------       |
          |             |                           |             |
          |             |<-ck                       |<-fixed      |
          |             |                           |             |
          |             |                           V             |
          |             |                 "MER-1_HGA_BORESIGHT"   |
          |             |                 ---------------------   |
          |             |                                         |
          |             v                                         |
          |      "MER-1_PMA_HEAD"                                 |
          |      +-----------------------------------------+      |
          |      |                    |                    |      |
          |      |<-fixed             |<-fixed      fixed->|      |
          |      |                    |                    |      |
          |      v                    v                    v      |
          |  "MER-1_PANCAM_*"  "MER-1_NAVCAM_*"  "MER-1_MINITES"  |
          |  ----------------  ----------------  ---------------  |
          |                                                       |
          |                                                       |
          |                                                       |
          |------------------------------+                        |
          |           (obsolete)         |                        |
          |<-ck                          |<-fixed                 |
          |                              |                        |
          v                              V                        |
      "MER-1_IDD_SHOULDER_AZ"     "MER-1_IDD_BASE"                |
      -----------------------     ----------------                |
          |                                                       |
          |<-ck                                                   |<-ck
          |                                                       |
          v                                                       v
      "MER-1_IDD_SHOULDER_EL"                             "MER-1_ROCKER_*"
      -----------------------         +-----------------------------------
          |                           |                           |
          |<-ck                       |<-ck                       |<-ck
          |                           |                           |
          v                           v                           v
      "MER-1_IDD_ELBOW"        "MER-1_STRUT_FRONT_*"       "MER-1_BOGEY_*"
      -----------------        ---------------------       ---------------
          |                                                       |
          |<-ck                                                   |<-ck
          |                                                       |
          v                                                       v
      "MER-1_IDD_WRIST"                               "MER-1_STRUT_REAR_*"
      -----------------                               --------------------
          |                                                        
          |<-ck                                                    
          |                                                        
          v                                                        
      "MER-1_IDD_TURRET"
      ------------------
          |                                                        
          |<-ck                                                    
          |                                                        
          v                                                        
      "MER-1_IDD_TURRET_HEAD"
      ------------------------------------------------------------+    
          |             |                           |             |
          |<-fixed      |<-fixed                    |<-fixed      |<-fixed
          |             |                           |             |
          v             v                           v             v
      "MER-1_APXS"  "MER-1_MICROIMAGER_F*"  "MER-1_MOSSBAUER"  "MER-1_RAT"  
      ------------  ----------------------  -----------------  -----------


   (1) While MER-1_CRUISE and MER-1_ROVER frames have constant orientation 
       with respect to each other during cruise, the frame tree implemented
       by this FK does not provide this orientation "connection".

   (2) While MER-1_LANDER and MER-1_ROVER frames have constant orientation 
       with respect to each other during cruise and up until the rover rolls
       off the lander, the frame tree implemented by this FK does not provide 
       this orientation "connection".

   (3) Although MGA, CLGA and BLGA are mounted on the cruise stage, for
       CK production convenience reasons they are specified as fixed offset
       frames with respect to the rover frame.


MER-1 EDL Frames
========================================================================

   This section contains the definition of the Mars Mean Equator and
   IAU vector of epoch inertial reference frame used as the reference
   frame deliver results of the MER-1 EDL trajectory solution by Robert
   C. Blanchard, (LARC-D205)[GWU] (see [7]).

   The transformation from the J2000 frame to this MME frame was
   provided in the MER-B ESF file ``esf_d_mer_b_od41.txt'':

   =======================================================================
   *
   Coordinate transformation matrix from Mars Mean Equator and IAU
   Vector of Date (IORB = -172) to Earth Mean Equator and Equinox OF
   J2000:
   *
       X                      Y                      Z
   X   6.733078544727115D-01 -5.895790701885213D-01  4.461536205176336D-01
   Y   7.393622475521413D-01  5.369062595566924D-01 -4.062943949200969D-01
   Z   0.0                    6.034303509473817D-01  7.974157081193721D-01
   =======================================================================

   The transpose of this matrix is provided in the frame definition
   below.

   \begindata

      FRAME_MER-1_EDL_MME          = -253930
      FRAME_-253930_NAME           = 'MER-1_EDL_MME'
      FRAME_-253930_CLASS          =  4
      FRAME_-253930_CLASS_ID       =  -253930
      FRAME_-253930_CENTER         =  -253930

      TKFRAME_-253930_RELATIVE     = 'J2000'
      TKFRAME_-253930_SPEC         = 'MATRIX'
      TKFRAME_-253930_MATRIX       = (

         6.733078544727115E-01  7.393622475521413E-01  0.0
        -5.895790701885213E-01  5.369062595566924E-01  6.034303509473817E-01
         4.461536205176336E-01 -4.062943949200969E-01  7.974157081193721E-01

                                     )

   \begintext


MER-1 Surface Frames
========================================================================

   The surface frames layout in this version of the FK is based on the
   assumption that the total traverse distance during the mission will
   be relatively short (hundreds of meters, not kilometers) and,
   therefore, the local north and nadir directions, defining surface
   frame orientations, will be approximately the same at any point
   along the traverse path. This assumption allows defining surface
   frames as fixed offset frames with respect to each other and/or to
   Mars body-fixed frame, IAU_MARS.

   This diagram illustrates MER-1 surface frames:

      <<TBD>>


MER-1 Topocentric Frame
-----------------------

   MER-1 topocentric frame, MER-1_TOPO, is defined as follows:

      -- +Z axis is along the outward normal at the landing site ("zenith");

      -- +X axis is along the local north direction ("north");

      -- +Y axis completes the right hand frame ("west");

      -- the origin of this frame is located at the landing site.

   Orientation of the frame is given relative to the body fixed
   rotating frame 'IAU_MARS' (x - along the line of zero longitude
   intersecting the equator, z - along the spin axis, y - completing
   the right hand coordinate frame.)

   The transformation from 'MER-1_TOPO' frame to 'IAU_MARS' frame is a
   3-2-3 rotation with defined angles as the negative of the site
   longitude, the negative of the site colatitude, 180 degrees.

   The TM20B3 (Meridiani Planum) landing site Gaussian longitude and
   latitude are:

        Lon = 354.060000 degrees East
        Lat =  -2.003511 degrees North

   These Gaussian coordinates correspond to the following areocentric
   coordinates (R, LON, LAT) = (3394.09, 354.060, -1.98) and Mars radii
   (Re, Re, Rp) = (3396.19, 3396.19, 3376.20).

   The actual landing site Gaussian longitude and latitude, derived from
   the landing site location determined by MER NAV team and provided in
   the RPF file "rpf_b_040128_0950_dte+ody.txt", are:

        Lon = 354.474170 degrees East
        Lat =  -1.971417 degrees North

   These Gaussian coordinates correspond to the following areocentric
   coordinates (R, LON, LAT) = (3394.1482, 354.47417, -1.9482823) and
   Mars radii (Re, Re, Rp) = (3396.19, 3396.19, 3376.20).

   The coordinates specified above are given with respect to the
   'IAU_MARS' instance defined by the rotation/shape model from the the
   PCK file 'mars_iau2000_v0.tpc'.

   These keywords implement the frame definition.

   \begindata

      FRAME_MER-1_TOPO             = -253900
      FRAME_-253900_NAME           = 'MER-1_TOPO'
      FRAME_-253900_CLASS          =  4
      FRAME_-253900_CLASS_ID       =  -253900
      FRAME_-253900_CENTER         =  -253900

      TKFRAME_-253900_RELATIVE     = 'IAU_MARS'
      TKFRAME_-253900_SPEC         = 'ANGLES'
      TKFRAME_-253900_UNITS        = 'DEGREES'
      TKFRAME_-253900_AXES         = ( 3, 2, 3 )
      TKFRAME_-253900_ANGLES       = ( -354.47417, -91.971417, 180.000  )

   \begintext


MER-1 Local Level Frame
-----------------------

   MER-1 local level frame, MER-1_LOCAL_LEVEL, is defined as follows:

      -- +Z axis is along the downward normal at the landing site ("nadir");

      -- +X axis is along the local north direction ("north");

      -- +Y axis completes the right hand frame ("east");

      -- the origin of this frame is located between the rover's middle wheels 
         and moves with the rover.
 
   Since this frame is essentially the MER-1_TOPO frame flipped by 180
   degrees about +X ("north") to point +Z down, this frame is defined
   as a fixed offset frame with respect to the MER-1_TOPO frame.

   \begindata

      FRAME_MER-1_LOCAL_LEVEL          = -253910
      FRAME_-253910_NAME               = 'MER-1_LOCAL_LEVEL'
      FRAME_-253910_CLASS              = 4
      FRAME_-253910_CLASS_ID           = -253910
      FRAME_-253910_CENTER             = -253900
      TKFRAME_-253910_RELATIVE         = 'MER-1_TOPO'
      TKFRAME_-253910_SPEC             = 'ANGLES'
      TKFRAME_-253910_UNITS            = 'DEGREES'
      TKFRAME_-253910_AXES             = (   1,       2,       3     )
      TKFRAME_-253910_ANGLES           = ( 180.000,   0.000,   0.000 )

   \begintext


MER-1 Surface Fixed Frame
-------------------------

   MER-1 surface fixed frame, MER-1_SURFACE_FIXED, frame is defined as
   follows:

      -- +Z axis is along the downward normal at the landing site ("nadir");

      -- +X axis is along the local north direction ("north");

      -- +Y axis completes the right hand frame ("east");

      -- the origin of this frame is located at the landing site.

   As seen from the definition, orientation-wise this frame is
   coincident with MER-1_LOCAL_LEVEL frame but its origin does not move
   during the mission. Therefore, this frame is defined as zero-offset
   frame with respect to the MER-1_LOCAL_LEVEL frame.

   \begindata

      FRAME_MER-1_SURFACE_FIXED        = -253920
      FRAME_-253920_NAME               = 'MER-1_SURFACE_FIXED'
      FRAME_-253920_CLASS              = 4
      FRAME_-253920_CLASS_ID           = -253920
      FRAME_-253920_CENTER             = -253900
      TKFRAME_-253920_RELATIVE         = 'MER-1_LOCAL_LEVEL'
      TKFRAME_-253920_SPEC             = 'ANGLES'
      TKFRAME_-253920_UNITS            = 'DEGREES'
      TKFRAME_-253920_AXES             = (   1,       2,       3     )
      TKFRAME_-253920_ANGLES           = (   0.000,   0.000,   0.000 )

   \begintext


MER-1 Rover, Lander, and Cruise Frames
========================================================================

   This diagram illustrates MER-1 cruise, rover, and lander frames:


                           Yc        Xc
                 .__________ <------o _________________.
                 |                  |                  |   Cruise 
                 ._________________ | _________________.    Stage
                                    |
                                    V Zc


                                 UHF    /\
                         HGA            \/ PMA
                          .--.    #     ||
                         /    \   #     ||
                        |      |  #     ||
                         \    /=. #     ||
                          `--' || #     ||                 Rover
                       =======================           (deployed)
                             |    =o=.    |
                             |  .' Yr `.__|o====o
                           .===o=== o------> Xr \\     
                          .-.      .|.    `.-.  ##o###
                         | o |    | | |   | o | 
                          `-'      `|'     `-'     IDD
                                    V Zr
                                     

                           Yl 
           .________________ <------o _______________.     Lander
           |_______________________ |Xl _____________|   (deployed)
                                    |
                                    |
                                    V Zl

                                     
MER-1 Rover Frame
-----------------

   MER-1 rover frame, MER-1_ROVER, is defined as follows:

      -- +Z axis is normal to the rover top deck plane and points down, from 
         the top deck toward the wheels;

      -- +X axis is parallel to the rover top deck plane and points from the 
         center of the top deck toward the PMA assembly;

      -- +Y completes the right hand frame;

   Orientation-wise this frame is the same as the Rover Mechanical and
   Rover Navigation frames defined in [4]. Since SPICE frames subsystem
   does not incorporate location information -- it is stored in the
   fixed offset SPK files -- this FK does not attempt to "map" the
   origin of the MER-1_ROVER to either Rover Navigation origin (located
   right above the middle wheels and shown on the diagram above and all
   other diagrams in this file) or Rover Mechanical frame origin
   (shifted by about 29 cm toward the front wheels). This "mapping" is
   done by defining a separate location for each of the two origins in
   the MER-1 fixed offset SPK file.

   During cruise this frame is rotated from the lander and cruise
   frames by +90 degrees about +Z axis. This orientation can also be
   provided in a CK file, but this frame seem to have no practical
   applications in cruise.

   During normal surface operations the MER-1_ROVER frame orientation
   with respect to the surface changes as the rover moves.
   Therefore, this frame is defined as a CK frame and the frame's
   orientation with respect to the MER-1_LOCAL_LEVEL frame is provided
   in the CK files.

   \begindata

      FRAME_MER-1_ROVER                = -253000
      FRAME_-253000_NAME               = 'MER-1_ROVER'
      FRAME_-253000_CLASS              = 3
      FRAME_-253000_CLASS_ID           = -253000
      FRAME_-253000_CENTER             = -253
      CK_-253000_SCLK                  = -253
      CK_-253000_SPK                   = -253000

   \begintext


MER-1 Lander Frame
------------------

   MER-1 lander frame, MER-1_LANDER, is defined as follows:

      -- +Z axis is normal to the lander base petal plane and points down, 
         from the upright lander toward the ground;

      -- +Y axis is parallel to the lander base petal plane and directed 
         outward passing through the geometric center of the rover petal;

      -- +X completes the right hand frame;

      -- the origin of this frame is located at the geometric center of the 
         the lander base petal;

   During cruise this frame is coincident orientation-wise with the
   cruise frame and is rotated by -90 degrees about +Z axis off the
   rover frame. Note that this frame has no practical applications in 
   cruise.

   During normal surface operations the MER-1_LANDER frame orientation
   with respect to the surface is fixed after landing (Even if it changes 
   after the rover rolls off, there is no practical sense in capturing the 
   change magnitude as the lander does not have any instruments of its own.) 
   Therefore, this frame is defined as a fixed offset frame with
   respect to the MER-1_LOCAL_LEVEL frame.

   Currently the keywords below define the lander frame's orientation to 
   be coincident with the local level frame -- +Z = nadir, +X = north, 
   +Y = east.

   \begindata

      FRAME_MER-1_LANDER               = -253700
      FRAME_-253700_NAME               = 'MER-1_LANDER'
      FRAME_-253700_CLASS              = 4
      FRAME_-253700_CLASS_ID           = -253700
      FRAME_-253700_CENTER             = -253
      TKFRAME_-253700_RELATIVE         = 'MER-1_LOCAL_LEVEL'
      TKFRAME_-253700_SPEC             = 'ANGLES'
      TKFRAME_-253700_UNITS            = 'DEGREES'
      TKFRAME_-253700_AXES             = (   1,       2,       3     )
      TKFRAME_-253700_ANGLES           = (   0.000,   0.000,   0.000 )

   \begintext


MER-1 Cruise Frame
------------------

   MER-1 cruise frame, MER-1_CRUISE, is defined as follows:

      -- +Z axis is parallel to s/c spin axis and points toward the end of 
         the aeroshell (in the launch direction);

      -- +Y axis is parallel to the spacecraft/launch vehicle interface 
         plane and point toward star scanner assembly;

      -- +X completes the right hand frame;

      -- the origin of this frame is at the geometric center of the spacecraft/
         launch vehicle interface ring.

   During cruise the MER-1_CRUISE frame orientation in inertial space 
   changes as the spacecraft approaches Mars. Therefore, this frame is 
   defined as a CK frame and the frame's orientation with respect to the 
   J2000 inertial frame is provided in the CK files.

   During cruise this frame is coincident orientation-wise with the
   lander frame and is rotated by -90 degrees about +Z axis off the
   rover frame.

   This frame has no practical application during surface operations.

   \begindata

      FRAME_MER-1_CRUISE               = -253800
      FRAME_-253800_NAME               = 'MER-1_CRUISE'
      FRAME_-253800_CLASS              = 3
      FRAME_-253800_CLASS_ID           = -253800
      FRAME_-253800_CENTER             = -253
      CK_-253800_SCLK                  = -253
      CK_-253800_SPK                   = -253800

   \begintext


MER-1 Rover HAZCAM Frames
========================================================================


MER-1 HAZCAM Frames
-------------------

   The frame for each of the four MER-1 HAZCAMs -- FRONT/LEFT, FRONT/RIGHT,
   REAR/LEFT, REAR/RIGHT -- is defined as follows:

      -- +Z axis is along the camera's central pixel view direction 
         ("into image");

      -- +Y axis is along the image central column and points from the
         image center toward the image top row ("up");

      -- +X completes the right hand frame and is along the image central
         row and points from the image center toward the image left 
         column ("left");

      -- the origin of the frame is located at the camera focal point.

   This diagram illustrates rover HAZCAM frames:


                                        /\ PMA
                         HGA            \/ 
                          .--.     UHF  ||
                          \   \   #     ||
                    Yhr ^  \   |  #     ||     ^Yhf
                         \  \ /=. #     ||    /
                          \  ' || #     ||   /          
                       ====\================/=          
          (out of page) Xhr o|    =o=.    |x Xhf (into page)
                          .' |  .' Yr `.__| `.
                        .' .===o=== o------>Xr`.
                       v  .-.      .|.    `.-.  v Zhf
                    Zhr  | o |    | | |   | o | 
                          `-'      `|'     `-'
                                    V Zr
                                                 (IDD is not shown)


   Since all HAZCAMs are rigidly mounted on the rover body, their frames 
   are defined as fixed offset frames with orientation given with respect 
   to the rover frame.

   Actual HAZCAM frame orientations will be derived from the final
   CAHVOR models as soon as such become available. Until then the frame
   orientations provided below are set to their nominal design values
   -- boresight in the direction of the rover +X and tilted 45 degrees
   toward the ground for FRONT HAZCAMs and in the direction of -X  and
   tilted 35 degrees toward the ground for REAR HAZCAMs. The
   following sets of keywords should be included into the frame
   definitions to provide this nominal orientation (provided for
   reference only):

      TKFRAME_-253011_AXES             = (   2,       1,       3     )
      TKFRAME_-253011_ANGLES           = ( -45.000,   0.000,  90.000 )

      TKFRAME_-253012_AXES             = (   2,       1,       3     )
      TKFRAME_-253012_ANGLES           = ( -45.000,   0.000,  90.000 )

      TKFRAME_-253021_AXES             = (   2,       1,       3     )
      TKFRAME_-253021_ANGLES           = (  55.000,   0.000, -90.000 )

      TKFRAME_-253022_AXES             = (   2,       1,       3     )
      TKFRAME_-253022_ANGLES           = (  55.000,   0.000, -90.000 )


   The actual MER-1_FRONT_HAZCAM_LEFT frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_33_SN_120.cahvore'. According to this model the reference frame,
   MER-1_ROVER, can be transformed into the camera frame,
   MER-1_FRONT_HAZCAM_LEFT, by the following sequence of rotations: first
   by 44.57202915 degrees about Y, then by -1.64874128 degrees about X, and
   finally by -89.38940093 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_FRONT_HAZCAM_LEFT    = -253011
      FRAME_-253011_NAME               = 'MER-1_FRONT_HAZCAM_LEFT'
      FRAME_-253011_CLASS              = 4
      FRAME_-253011_CLASS_ID           = -253011
      FRAME_-253011_CENTER             = -253
      TKFRAME_-253011_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253011_SPEC             = 'ANGLES'
      TKFRAME_-253011_UNITS            = 'DEGREES'
      TKFRAME_-253011_AXES             = (    2,        1,        3     )
      TKFRAME_-253011_ANGLES           = (  -44.572,    1.649,   89.389 )

   \begintext


   The actual MER-1_FRONT_HAZCAM_RIGHT frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_34_SN_122.cahvore'. According to this model the reference frame,
   MER-1_ROVER, can be transformed into the camera frame,
   MER-1_FRONT_HAZCAM_RIGHT, by the following sequence of rotations: first
   by 44.52764887 degrees about Y, then by -1.63790800 degrees about X, and
   finally by -90.44000254 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_FRONT_HAZCAM_RIGHT   = -253012
      FRAME_-253012_NAME               = 'MER-1_FRONT_HAZCAM_RIGHT'
      FRAME_-253012_CLASS              = 4
      FRAME_-253012_CLASS_ID           = -253012
      FRAME_-253012_CENTER             = -253
      TKFRAME_-253012_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253012_SPEC             = 'ANGLES'
      TKFRAME_-253012_UNITS            = 'DEGREES'
      TKFRAME_-253012_AXES             = (    2,        1,        3     )
      TKFRAME_-253012_ANGLES           = (  -44.528,    1.638,   90.440 )

   \begintext


   The actual MER-1_REAR_HAZCAM_LEFT frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_35_SN_119.cahvore'. According to this model the reference frame,
   MER-1_ROVER, can be transformed into the camera frame,
   MER-1_REAR_HAZCAM_LEFT, by the following sequence of rotations: first
   by -54.60147480 degrees about Y, then by 0.61135780 degrees about X, and
   finally by 90.78609394 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_REAR_HAZCAM_LEFT     = -253021
      FRAME_-253021_NAME               = 'MER-1_REAR_HAZCAM_LEFT'
      FRAME_-253021_CLASS              = 4
      FRAME_-253021_CLASS_ID           = -253021
      FRAME_-253021_CENTER             = -253
      TKFRAME_-253021_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253021_SPEC             = 'ANGLES'
      TKFRAME_-253021_UNITS            = 'DEGREES'
      TKFRAME_-253021_AXES             = (    2,        1,        3     )
      TKFRAME_-253021_ANGLES           = (   54.601,   -0.611,  -90.786 )

   \begintext


   The actual MER-1_REAR_HAZCAM_RIGHT frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_36_SN_121.cahvore'. According to this model the reference frame,
   MER-1_ROVER, can be transformed into the camera frame,
   MER-1_REAR_HAZCAM_RIGHT, by the following sequence of rotations: first
   by -54.41121313 degrees about Y, then by 0.62900544 degrees about X, and
   finally by 90.20669593 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_REAR_HAZCAM_RIGHT    = -253022
      FRAME_-253022_NAME               = 'MER-1_REAR_HAZCAM_RIGHT'
      FRAME_-253022_CLASS              = 4
      FRAME_-253022_CLASS_ID           = -253022
      FRAME_-253022_CENTER             = -253
      TKFRAME_-253022_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253022_SPEC             = 'ANGLES'
      TKFRAME_-253022_UNITS            = 'DEGREES'
      TKFRAME_-253022_AXES             = (    2,        1,        3     )
      TKFRAME_-253022_ANGLES           = (   54.411,   -0.629,  -90.207 )

   \begintext


MER-1 PMA Structures and PMA-Mounted Instrument Frames
========================================================================


MER-1 PMA "zero" AZ, PMA Base, and PMA "zero" EL Frames
-------------------------------------------------------

   MER-1 PMA "zero" AZ frame is introduced to capture offset between
   the rover X axis and the direction (in horizontal plane) along which
   the PMA head is pointing at "zero" AZ & EL gimbal angles. Ideally
   this frame is co-aligned with the rover frame. In reality, its
   rotational offset about +Z axis from the rover frame is not zero.
   This frame is defined as a fixed offset frame w.r.t. the rover
   frame.

   MER-1 PMA base frame, MER-1_PMA_BASE, is rotated from the "zero" AZ
   frame by PMA AZ angle about +Z axis. This frame is defined as a
   CK-based frame.

   MER-1 PMA "zero" EL frame is introduced to capture offset between
   the rover XY plane and the direction (in vertical plane) along which
   the PMA head is pointing at "zero" AZ & EL gimbal angles. Ideally
   this frame is co-aligned with the PMA base frame. In reality, its
   rotational offset about +Y axis from the PMA base frame is not zero.
   This frame is defined as a fixed offset frame w.r.t. the PMA base
   frame.

   The actual AZ and EL offset angles, incorporated into the "zero" AZ
   and EL frame definitions, are:

       FLIGHT AZ offset    =  0.266769 deg 
       FLIGHT EL offset    =  3.589982 deg

   These are the PMA "zero" AZ, PMA base, and PMA "zero" EL frame
   definitions.

   \begindata

      FRAME_MER-1_PMA_ZERO_AZ          = -253101
      FRAME_-253101_NAME               = 'MER-1_PMA_ZERO_AZ'
      FRAME_-253101_CLASS              = 4
      FRAME_-253101_CLASS_ID           = -253101
      FRAME_-253101_CENTER             = -253
      TKFRAME_-253101_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253101_SPEC             = 'ANGLES'
      TKFRAME_-253101_UNITS            = 'DEGREES'
      TKFRAME_-253101_AXES             = (   2,       1,       3        )
      TKFRAME_-253101_ANGLES           = (   0.000,   0.000,  -0.266769 )

      FRAME_MER-1_PMA_BASE             = -253100
      FRAME_-253100_NAME               = 'MER-1_PMA_BASE'
      FRAME_-253100_CLASS              = 3
      FRAME_-253100_CLASS_ID           = -253100
      FRAME_-253100_CENTER             = -253
      CK_-253100_SCLK                  = -253
      CK_-253100_SPK                   = -253100

      FRAME_MER-1_PMA_ZERO_EL          = -253102
      FRAME_-253102_NAME               = 'MER-1_PMA_ZERO_EL'
      FRAME_-253102_CLASS              = 4
      FRAME_-253102_CLASS_ID           = -253102
      FRAME_-253102_CENTER             = -253
      TKFRAME_-253102_RELATIVE         = 'MER-1_PMA_BASE'
      TKFRAME_-253102_SPEC             = 'ANGLES'
      TKFRAME_-253102_UNITS            = 'DEGREES'
      TKFRAME_-253102_AXES             = (   2,          1,       3     )
      TKFRAME_-253102_ANGLES           = (  -3.589982,   0.000,   0.000 )

   \begintext


MER-1 PMA Head Frame
--------------------

   MER-1 PMA head frame, MER-1_PMA_HEAD, is defined as follows:

      -- +X axis is in the direction of the nominal NAVCAM boresight;

      -- +Y axis is along PMA head elevation rotation axis and points
         from the left NAVCAM toward the right NAVCAM;

      -- +Z completes the right hand frame;

      -- the origin of this frame is at the intersection of the PMA azimuth 
         and elevation rotation axes.

   During normal surface operations the MER-1_PMA_HEAD frame
   orientation with respect to the PMA base frame is varying and
   controlled using azimuth and elevation angles. Therefore, this frame
   is defined as a CK frame and the frame's orientation with respect to
   the MER-1_PMA_ZERO_EL frame is provided in the CK files.

   Ideally, for zero azimuth and elevation position this frame is
   coincident in orientation with the PMA rover frame.
   
   \begindata

      FRAME_MER-1_PMA_HEAD             = -253110
      FRAME_-253110_NAME               = 'MER-1_PMA_HEAD'
      FRAME_-253110_CLASS              = 3
      FRAME_-253110_CLASS_ID           = -253110
      FRAME_-253110_CENTER             = -253
      CK_-253110_SCLK                  = -253
      CK_-253110_SPK                   = -253110

   \begintext


MER-1 PANCAM and NAVCAM Frames
------------------------------

   The frame for each of the two MER-1 NAVCAM cameras -- LEFT and
   RIGHT, -- and the 16 PANCAM camera/filter combinations is defined
   as follows:

      -- +Z axis is along the camera's central pixel view direction 
         ("into image");

      -- +Y axis is along the image central column and points from the
         image center toward the image top row ("up");

      -- +X completes the right hand frame and is along the image central
         row and points from the image center toward the image left 
         column ("left");

      -- the origin of the frame is located at the camera focal point.

   Since both NAVCAM and PANCAM cameras are rigidly mounted on the PMA
   head, their frames are defined as fixed offset frames with
   orientation given with respect to the PMA head frame.

   This diagram illustrates PMA base, head, and instrument frames (zero 
   AZ/EL position):

      PMA side view:
      --------------

                                       Ynavcam(l,r) 
                                        Ypancam(l,r)
                                       ^^
                                       ||          
                                   .-. ||
                                   | |-||       Znavcam(l,r)
                                   | | xx----->> Zpancam(l,r)
                           Yminites|^|--'
                                  .-|-.    
                                .'  |  `.  <--- Elevation Drive
                     Zminites  /    |    \
                             <------o------> 
                               \    |    /  Xpma_head
                                `.  |  .'
                                  |-| Zpma_head
                  PMA Head      .___V___.
                   ............ |...o------> 
               Mounting Plane   `---|---'   Xpma_base
                                  | | |
                                  | | |
                                  | V Zpma_base
                ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
                ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
                               .----|----. 
                               |    | <--- Azimuth Drive & Rotation Axis
                               .----|----'
                                  |   .'\ 
                                  | .'.' 
                                  .'.' |
                                 \.'   |
                -------------------------------.
                -------------------------------'
                                         |
                ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
                ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
                         Yr              |
                 o------>      ----------'
                 |       Xr
                 |
                 |                             Yr, Ypma_base, Ypma_head,
                 V Zr                          Xminites are out of page

                                              Xnavcam(l,r), Xpancam(l,r)
                                                    are into page.


      PMA top view:
      -------------
                                    |
                                    | <--- Elevation rotation axis
                                    |

                                        ^ Xpancam(l)
                               .________|.
                               |   ._.  ||Xnavcam(l)
                               |   | |_^||
                               |   | | |o------> Zpancam(l)
                               |   | |-|'|
                               |   | |-| |
                               |   | | o------> Znavcam(l)
           Zr       Xr         |   | |-' |
              x------>    Zpma_head  |   |
              |           Zpma_base  |   |
              |                |   |x------>Xpma_head
              |                |   |||   |  Xpma_base
           Yr v                |   |||   |                 
                          Ypma_head ||   |  
                          Ypma_base V| ^ Xnavcam(r)  
                              .----| | | |
                              |    | | | |Xpancam(r)
                     Zminites  <----o|_|^|
                              |    ||| o|-----> Znavcam(r)
                              `----|||-'||
                               |   |||--||
                               |   |V|  o------> Zpancam(r)
                           Xminites| |--'|
                               |   ._.   |
                               .___._.___.

                                               Zr, Zpma_base, Zpma_head,
                                                 are into page.

                                              Ynavcam(l,r), Ypancam(l,r)
                                              and Yminites are out of page.


   Nominal PMA camera orientations are such that NAVCAM left and right
   boresights are parallel to each other and the PMA head +X axis,
   while the PANCAM left and right boresights "toe"ed in by 1 degree
   toward the PMA head +X axis. In order align PMA head frame with the
   camera frames in this nominal orientation, it has to be rotated by
   +90 degrees about Y and then about X by non-zero "toe"-ins for the
   PANCAM (-1 degree for the left camera and +1 degree for the right
   camera) and by zero "toe"-ins for NAVCAM, and finally by -90 degrees
   about Z (to line up Y axis with the vertical direction.) The
   following sets of keywords should be included into the frame
   definitions to provide this nominal orientation (provided for
   reference only):

      TKFRAME_-253111_AXES             = (   2,       1,       3     )
      TKFRAME_-253111_ANGLES           = ( -90.000,   0.000,  90.000 )

      TKFRAME_-253112_AXES             = (   2,       1,       3     )
      TKFRAME_-253112_ANGLES           = ( -90.000,   0.000,  90.000 )

      TKFRAME_-253121_AXES             = (   2,       1,       3     )
      TKFRAME_-253121_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253122_AXES             = (   2,       1,       3     )
      TKFRAME_-253122_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253123_AXES             = (   2,       1,       3     )
      TKFRAME_-253123_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253124_AXES             = (   2,       1,       3     )
      TKFRAME_-253124_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253125_AXES             = (   2,       1,       3     )
      TKFRAME_-253125_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253126_AXES             = (   2,       1,       3     )
      TKFRAME_-253126_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253127_AXES             = (   2,       1,       3     )
      TKFRAME_-253127_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253128_AXES             = (   2,       1,       3     )
      TKFRAME_-253128_ANGLES           = ( -90.000,   1.000,  90.000 )

      TKFRAME_-253131_AXES             = (   2,       1,       3     )
      TKFRAME_-253131_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253132_AXES             = (   2,       1,       3     )
      TKFRAME_-253132_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253133_AXES             = (   2,       1,       3     )
      TKFRAME_-253133_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253134_AXES             = (   2,       1,       3     )
      TKFRAME_-253134_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253135_AXES             = (   2,       1,       3     )
      TKFRAME_-253135_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253136_AXES             = (   2,       1,       3     )
      TKFRAME_-253136_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253137_AXES             = (   2,       1,       3     )
      TKFRAME_-253137_ANGLES           = ( -90.000,  -1.000,  90.000 )

      TKFRAME_-253138_AXES             = (   2,       1,       3     )
      TKFRAME_-253138_ANGLES           = ( -90.000,  -1.000,  90.000 )


   The actual MER-1_NAVCAM_LEFT frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_196_SN_102.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_NAVCAM_LEFT, by the following sequence of rotations: first
   by 89.61611519 degrees about Y, then by 0.04108109 degrees about X, and
   finally by -89.98466534 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_NAVCAM_LEFT          = -253111
      FRAME_-253111_NAME               = 'MER-1_NAVCAM_LEFT'
      FRAME_-253111_CLASS              = 4
      FRAME_-253111_CLASS_ID           = -253111
      FRAME_-253111_CENTER             = -253
      TKFRAME_-253111_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253111_SPEC             = 'ANGLES'
      TKFRAME_-253111_UNITS            = 'DEGREES'
      TKFRAME_-253111_AXES             = (    2,        1,        3     )
      TKFRAME_-253111_ANGLES           = (  -89.616,   -0.041,   89.985 )

   \begintext


   The actual MER-1_NAVCAM_RIGHT frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_197_SN_117.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_NAVCAM_RIGHT, by the following sequence of rotations: first
   by 89.59863960 degrees about Y, then by -0.02778846 degrees about X, and
   finally by -90.11882165 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_NAVCAM_RIGHT         = -253112
      FRAME_-253112_NAME               = 'MER-1_NAVCAM_RIGHT'
      FRAME_-253112_CLASS              = 4
      FRAME_-253112_CLASS_ID           = -253112
      FRAME_-253112_CENTER             = -253
      TKFRAME_-253112_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253112_SPEC             = 'ANGLES'
      TKFRAME_-253112_UNITS            = 'DEGREES'
      TKFRAME_-253112_AXES             = (    2,        1,        3     )
      TKFRAME_-253112_ANGLES           = (  -89.599,    0.028,   90.119 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F1 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_198_SN_115_F_1.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F1, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F1       = -253121
      FRAME_-253121_NAME               = 'MER-1_PANCAM_LEFT_F1'
      FRAME_-253121_CLASS              = 4
      FRAME_-253121_CLASS_ID           = -253121
      FRAME_-253121_CENTER             = -253
      TKFRAME_-253121_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253121_SPEC             = 'ANGLES'
      TKFRAME_-253121_UNITS            = 'DEGREES'
      TKFRAME_-253121_AXES             = (    2,        1,        3     )
      TKFRAME_-253121_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F2 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_199_SN_115_F_2.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F2, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F2       = -253122
      FRAME_-253122_NAME               = 'MER-1_PANCAM_LEFT_F2'
      FRAME_-253122_CLASS              = 4
      FRAME_-253122_CLASS_ID           = -253122
      FRAME_-253122_CENTER             = -253
      TKFRAME_-253122_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253122_SPEC             = 'ANGLES'
      TKFRAME_-253122_UNITS            = 'DEGREES'
      TKFRAME_-253122_AXES             = (    2,        1,        3     )
      TKFRAME_-253122_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F3 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_200_SN_115_F_3.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F3, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F3       = -253123
      FRAME_-253123_NAME               = 'MER-1_PANCAM_LEFT_F3'
      FRAME_-253123_CLASS              = 4
      FRAME_-253123_CLASS_ID           = -253123
      FRAME_-253123_CENTER             = -253
      TKFRAME_-253123_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253123_SPEC             = 'ANGLES'
      TKFRAME_-253123_UNITS            = 'DEGREES'
      TKFRAME_-253123_AXES             = (    2,        1,        3     )
      TKFRAME_-253123_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F4 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_201_SN_115_F_4.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F4, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F4       = -253124
      FRAME_-253124_NAME               = 'MER-1_PANCAM_LEFT_F4'
      FRAME_-253124_CLASS              = 4
      FRAME_-253124_CLASS_ID           = -253124
      FRAME_-253124_CENTER             = -253
      TKFRAME_-253124_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253124_SPEC             = 'ANGLES'
      TKFRAME_-253124_UNITS            = 'DEGREES'
      TKFRAME_-253124_AXES             = (    2,        1,        3     )
      TKFRAME_-253124_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F5 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_202_SN_115_F_5.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F5, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F5       = -253125
      FRAME_-253125_NAME               = 'MER-1_PANCAM_LEFT_F5'
      FRAME_-253125_CLASS              = 4
      FRAME_-253125_CLASS_ID           = -253125
      FRAME_-253125_CENTER             = -253
      TKFRAME_-253125_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253125_SPEC             = 'ANGLES'
      TKFRAME_-253125_UNITS            = 'DEGREES'
      TKFRAME_-253125_AXES             = (    2,        1,        3     )
      TKFRAME_-253125_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F6 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_203_SN_115_F_6.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F6, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F6       = -253126
      FRAME_-253126_NAME               = 'MER-1_PANCAM_LEFT_F6'
      FRAME_-253126_CLASS              = 4
      FRAME_-253126_CLASS_ID           = -253126
      FRAME_-253126_CENTER             = -253
      TKFRAME_-253126_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253126_SPEC             = 'ANGLES'
      TKFRAME_-253126_UNITS            = 'DEGREES'
      TKFRAME_-253126_AXES             = (    2,        1,        3     )
      TKFRAME_-253126_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F7 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_204_SN_115_F_7.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F7, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F7       = -253127
      FRAME_-253127_NAME               = 'MER-1_PANCAM_LEFT_F7'
      FRAME_-253127_CLASS              = 4
      FRAME_-253127_CLASS_ID           = -253127
      FRAME_-253127_CENTER             = -253
      TKFRAME_-253127_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253127_SPEC             = 'ANGLES'
      TKFRAME_-253127_UNITS            = 'DEGREES'
      TKFRAME_-253127_AXES             = (    2,        1,        3     )
      TKFRAME_-253127_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_LEFT_F8 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_205_SN_115_F_8.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_LEFT_F8, by the following sequence of rotations: first
   by 89.97776499 degrees about Y, then by -1.12037549 degrees about X, and
   finally by -90.16528032 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_LEFT_F8       = -253128
      FRAME_-253128_NAME               = 'MER-1_PANCAM_LEFT_F8'
      FRAME_-253128_CLASS              = 4
      FRAME_-253128_CLASS_ID           = -253128
      FRAME_-253128_CENTER             = -253
      TKFRAME_-253128_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253128_SPEC             = 'ANGLES'
      TKFRAME_-253128_UNITS            = 'DEGREES'
      TKFRAME_-253128_AXES             = (    2,        1,        3     )
      TKFRAME_-253128_ANGLES           = (  -89.978,    1.120,   90.165 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F1 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_206_SN_114_F_1.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F1, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F1      = -253131
      FRAME_-253131_NAME               = 'MER-1_PANCAM_RIGHT_F1'
      FRAME_-253131_CLASS              = 4
      FRAME_-253131_CLASS_ID           = -253131
      FRAME_-253131_CENTER             = -253
      TKFRAME_-253131_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253131_SPEC             = 'ANGLES'
      TKFRAME_-253131_UNITS            = 'DEGREES'
      TKFRAME_-253131_AXES             = (    2,        1,        3     )
      TKFRAME_-253131_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F2 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_207_SN_114_F_2.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F2, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F2      = -253132
      FRAME_-253132_NAME               = 'MER-1_PANCAM_RIGHT_F2'
      FRAME_-253132_CLASS              = 4
      FRAME_-253132_CLASS_ID           = -253132
      FRAME_-253132_CENTER             = -253
      TKFRAME_-253132_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253132_SPEC             = 'ANGLES'
      TKFRAME_-253132_UNITS            = 'DEGREES'
      TKFRAME_-253132_AXES             = (    2,        1,        3     )
      TKFRAME_-253132_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F3 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_208_SN_114_F_3.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F3, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F3      = -253133
      FRAME_-253133_NAME               = 'MER-1_PANCAM_RIGHT_F3'
      FRAME_-253133_CLASS              = 4
      FRAME_-253133_CLASS_ID           = -253133
      FRAME_-253133_CENTER             = -253
      TKFRAME_-253133_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253133_SPEC             = 'ANGLES'
      TKFRAME_-253133_UNITS            = 'DEGREES'
      TKFRAME_-253133_AXES             = (    2,        1,        3     )
      TKFRAME_-253133_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F4 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_209_SN_114_F_4.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F4, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F4      = -253134
      FRAME_-253134_NAME               = 'MER-1_PANCAM_RIGHT_F4'
      FRAME_-253134_CLASS              = 4
      FRAME_-253134_CLASS_ID           = -253134
      FRAME_-253134_CENTER             = -253
      TKFRAME_-253134_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253134_SPEC             = 'ANGLES'
      TKFRAME_-253134_UNITS            = 'DEGREES'
      TKFRAME_-253134_AXES             = (    2,        1,        3     )
      TKFRAME_-253134_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F5 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_210_SN_114_F_5.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F5, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F5      = -253135
      FRAME_-253135_NAME               = 'MER-1_PANCAM_RIGHT_F5'
      FRAME_-253135_CLASS              = 4
      FRAME_-253135_CLASS_ID           = -253135
      FRAME_-253135_CENTER             = -253
      TKFRAME_-253135_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253135_SPEC             = 'ANGLES'
      TKFRAME_-253135_UNITS            = 'DEGREES'
      TKFRAME_-253135_AXES             = (    2,        1,        3     )
      TKFRAME_-253135_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F6 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_211_SN_114_F_6.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F6, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F6      = -253136
      FRAME_-253136_NAME               = 'MER-1_PANCAM_RIGHT_F6'
      FRAME_-253136_CLASS              = 4
      FRAME_-253136_CLASS_ID           = -253136
      FRAME_-253136_CENTER             = -253
      TKFRAME_-253136_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253136_SPEC             = 'ANGLES'
      TKFRAME_-253136_UNITS            = 'DEGREES'
      TKFRAME_-253136_AXES             = (    2,        1,        3     )
      TKFRAME_-253136_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F7 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_212_SN_114_F_7.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F7, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F7      = -253137
      FRAME_-253137_NAME               = 'MER-1_PANCAM_RIGHT_F7'
      FRAME_-253137_CLASS              = 4
      FRAME_-253137_CLASS_ID           = -253137
      FRAME_-253137_CENTER             = -253
      TKFRAME_-253137_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253137_SPEC             = 'ANGLES'
      TKFRAME_-253137_UNITS            = 'DEGREES'
      TKFRAME_-253137_AXES             = (    2,        1,        3     )
      TKFRAME_-253137_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


   The actual MER-1_PANCAM_RIGHT_F8 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_213_SN_114_F_8.cahvor'. According to this model the reference frame,
   MER-1_PMA_HEAD, can be transformed into the camera frame,
   MER-1_PANCAM_RIGHT_F8, by the following sequence of rotations: first
   by 90.03186072 degrees about Y, then by 0.93699977 degrees about X, and
   finally by -90.18278388 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_PANCAM_RIGHT_F8      = -253138
      FRAME_-253138_NAME               = 'MER-1_PANCAM_RIGHT_F8'
      FRAME_-253138_CLASS              = 4
      FRAME_-253138_CLASS_ID           = -253138
      FRAME_-253138_CENTER             = -253
      TKFRAME_-253138_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253138_SPEC             = 'ANGLES'
      TKFRAME_-253138_UNITS            = 'DEGREES'
      TKFRAME_-253138_AXES             = (    2,        1,        3     )
      TKFRAME_-253138_ANGLES           = (  -90.032,   -0.937,   90.183 )

   \begintext


MER-1 MINI-TES Frame
--------------------

   The frame for Mini-TES is defined as follows:

      -- +Z axis is along the instrument boresight defined as the central 
         pixel view direction ("into image");

      -- +Y axis is along the image central column and points from the
         image center toward the image top row ("up");

      -- +X completes the right hand frame and is along the image central
         row and points from the image center toward the image left 
         column ("left");

      -- the origin of the frame is located at the instrument's focal point.

   Since Mini-TES is rigidly mounted on the PMA head, its frame is
   defined as fixed offset frame with orientation given with respect to
   the PMA head frame.

   Actual Mini-TEST frame orientation will be derived from the final
   instrument geometric model as soon as such becomes available. Until
   then the frame orientation provided below is set in accordance with
   the nominal design -- Mini-TES boresight parallel to the PMA head -X
   axis. In order align PMA head frame with the Mini-TES frame in this
   nominal orientation, it has to be rotated by -90 degrees about Y and
   then by +90 degrees about +Z.

   \begindata

      FRAME_MER-1_MINITES             = -253140
      FRAME_-253140_NAME               = 'MER-1_MINITES'
      FRAME_-253140_CLASS              = 4
      FRAME_-253140_CLASS_ID           = -253140
      FRAME_-253140_CENTER             = -253
      TKFRAME_-253140_RELATIVE         = 'MER-1_PMA_HEAD'
      TKFRAME_-253140_SPEC             = 'ANGLES'
      TKFRAME_-253140_UNITS            = 'DEGREES'
      TKFRAME_-253140_AXES             = (   2,       1,       3     )
      TKFRAME_-253140_ANGLES           = (  90.000,   0.000, -90.000 )

   \begintext


MER-1 IDD Structures and IDD-Mounted Instrument Frames
========================================================================


MER-1 IDD Structures Frames
---------------------------

   MER-1 IDD base frame, MER-1_IDD_BASE, called in [5] IDD_MNT frame,
   is defined to be coincident in orientation with the rover frame. The
   origin of this frame is at center of the registration pin in the IDD
   mounting plate.

   THIS FRAME, MER-1_IDD_BASE, IS OBSOLETE BECAUSE IT ENDED UP NO BEING
   USED FOR ANYTHING. IT IS KEEP IN THE FK FOR MAINTENANCE REASONS.

   Since this frame is fixed with respect to and coincident with the rover 
   it's defined as zero offset frame with respect to the rover frame.
   
   \begindata

      FRAME_MER-1_IDD_BASE             = -253200
      FRAME_-253200_NAME               = 'MER-1_IDD_BASE'
      FRAME_-253200_CLASS              = 4
      FRAME_-253200_CLASS_ID           = -253200
      FRAME_-253200_CENTER             = -253
      TKFRAME_-253200_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253200_SPEC             = 'ANGLES'
      TKFRAME_-253200_UNITS            = 'DEGREES'
      TKFRAME_-253200_AXES             = (   1,       2,       3     )
      TKFRAME_-253200_ANGLES           = (   0.000,   0.000,   0.000 )


   \begintext

   All MER-1 IDD joint frames -- SHOULDER_AZ, SHOULDER_EL, ELBOW,
   WRIST, and TURRET, enumerated in [5] as IDD0...IDD4 frames -- are
   defined in accordance with normal kinematics convention as follows:

      -- +Z axis is along the joint rotation axis, nominally pointing
         along rover +Z for SHOULDER_AZ, along rover -Y (for IDD in 
         straight out position) for SHOULDER_EL, ELBOW, and WRIST, and
         along wrist +Y for TURRET;

      -- +X axis is along the link attached to the joint;

      -- +Y completes the right hand frame;

      -- the origin lies on the rotation axis at a point that provides for 
         the minimum magnitude of translations between the joints
         (see diagram above).

   This diagram illustrates IDD base and joint frames in "zero joint
   rotation" position:


      IDD side view:
      -------------

              Shoulder/Az                                Turret
                 axis                                     axis

                   |                                        |
                   .                                        .
                   |                                        |

              ////////                               APXS .___. RAT 
             //Rover//                                    |   |     
             /////////   Xsh_az                           | o------>
              /////o------>                               ._|_.  Xtr
                 | | | .-.               .-.               .|.      
                 | | || x------> =======| x------> =======| x------>
            Zsh_az_|_. `|   Xsh_el       `|'    Xelb    Ztr`V'   Xwr
                   V    |                 |                 |       
                        |                 |                 |
         o------>       V Ysh_el          V Yelb            V Ywr
         |     Xr 
         |
         |
         V                          Yr, Ybase, Ysh_az, Ytr are out of page;
          Zr                             Zsh_el, Zelb, Zwr are into page.


      IDD top view:
      ------------

                    Shoulder/El         Elbow             Wrist
                       axis             axis              axis

                        |                 |                 |
                        .                 .                 .
                        |                 |                 |
                        
               //////    Zsh_el            Zelb              Zwr
             ////////   ^                 ^                 ^
             /Rover// ._|_.             ._|_.               |
             //////// | | |-------------| | |               |       
             /////.-. | | |-------------| | |  Xelb       ._|_.  Xwr
             ////| x----x->---->        | x------> -------| x------>
             /////`|' Xsh_az  Xsh_el    ._|_.-------------|   |     
             //////|/                                     | MI|     
             //////|/                                     |.-.|  Xtr
              /////V/ Ysh_az                         APXS | x--RAT->
                /////                                      `|'      
                                                           MSB      
                                                            |
         x------> Xr                                        V Ytr
         |
         |
         |                                    Zr, Zbase, Zsh_az, Ysh_el, 
         V Yr                                 Yelb, Ywr, and Ztr are all
                                                      into the page
                                

   During normal surface operations the orientation of each of these
   frames with respect to each other varies and is controlled and 
   telemetered using IDD joint angles. Therefore, these frame are
   defined as a CK frames with the orientation for each frame provided
   with respect to its parent in the frame chain.

   \begindata

      FRAME_MER-1_IDD_SHOULDER_AZ      = -253201
      FRAME_-253201_NAME               = 'MER-1_IDD_SHOULDER_AZ'
      FRAME_-253201_CLASS              = 3
      FRAME_-253201_CLASS_ID           = -253201
      FRAME_-253201_CENTER             = -253
      CK_-253201_SCLK                  = -253
      CK_-253201_SPK                   = -253201

      FRAME_MER-1_IDD_SHOULDER_EL      = -253202
      FRAME_-253202_NAME               = 'MER-1_IDD_SHOULDER_EL'
      FRAME_-253202_CLASS              = 3
      FRAME_-253202_CLASS_ID           = -253202
      FRAME_-253202_CENTER             = -253
      CK_-253202_SCLK                  = -253
      CK_-253202_SPK                   = -253202

      FRAME_MER-1_IDD_ELBOW            = -253203
      FRAME_-253203_NAME               = 'MER-1_IDD_ELBOW'
      FRAME_-253203_CLASS              = 3
      FRAME_-253203_CLASS_ID           = -253203
      FRAME_-253203_CENTER             = -253
      CK_-253203_SCLK                  = -253
      CK_-253203_SPK                   = -253203

      FRAME_MER-1_IDD_WRIST            = -253204
      FRAME_-253204_NAME               = 'MER-1_IDD_WRIST'
      FRAME_-253204_CLASS              = 3
      FRAME_-253204_CLASS_ID           = -253204
      FRAME_-253204_CENTER             = -253
      CK_-253204_SCLK                  = -253
      CK_-253204_SPK                   = -253204

      FRAME_MER-1_IDD_TURRET           = -253205
      FRAME_-253205_NAME               = 'MER-1_IDD_TURRET'
      FRAME_-253205_CLASS              = 3
      FRAME_-253205_CLASS_ID           = -253205
      FRAME_-253205_CENTER             = -253
      CK_-253205_SCLK                  = -253
      CK_-253205_SPK                   = -253205

   \begintext


MER-1 IDD Instrument Frames
---------------------------

   MER-1 TURRET HEAD frame, enumerated as IDD5 in [5], is defined as
   follows:

      -- +Z axis is along the nominal Micro-Imager boresight;

      -- +Y axis is along the turret rotation axis;

      -- +X axis completes the right frame;

      -- the origin is at the intersection of the nominal turret rotation 
         axis and Micro-Imager boresight;

   Although this frame is fixed with respect to the MER-1_IDD_TURRET 
   frame, is nominally rotated from it by +90 degrees about +X axis, and
   was defined as a fixed offset frame using these keywords:

      FRAME_MER-1_IDD_TURRET_HEAD      = -253206
      FRAME_-253206_NAME               = 'MER-1_IDD_TURRET_HEAD'
      FRAME_-253206_CLASS              = 4
      FRAME_-253206_CLASS_ID           = -253206
      FRAME_-253206_CENTER             = -253
      TKFRAME_-253206_RELATIVE         = 'MER-1_IDD_TURRET'
      TKFRAME_-253206_SPEC             = 'ANGLES'
      TKFRAME_-253206_UNITS            = 'DEGREES'
      TKFRAME_-253206_AXES             = (   1,       2,       3     )
      TKFRAME_-253206_ANGLES           = ( -90.000,   0.000,   0.000 )

   in the FK versions 0.5 and below, it was re-classified as CK-based
   frame to allow storing its deflected orientation directly w.r.t. to
   the ROVER frame.

   \begindata

      FRAME_MER-1_IDD_TURRET_HEAD      = -253206
      FRAME_-253206_NAME               = 'MER-1_IDD_TURRET_HEAD'
      FRAME_-253206_CLASS              = 3
      FRAME_-253206_CLASS_ID           = -253206
      FRAME_-253206_CENTER             = -253
      CK_-253206_SCLK                  = -253
      CK_-253206_SPK                   = -253206

   \begintext

   MER-1 IDD instrument frames -- MICROIMAGER_F1 (closed cover),
   MICROIMAGER_F1 (open cover), APXS, RAT, and MOSSBAUER -- are fixed
   with respect to the TURRET_HEAD frame and are nominally rotated from
   it about Y axis by the following angles (from [5]):
 
       Instrument     Angle, deg
      -------------   ----------
      MICROIMAGER         0.0
      RAT                90.0
      MOSSBAUER         180.0
      APXS              270.0

   The actual calibrated values of these angles from [6] are:

       Instrument      Angle, rad
      -------------   -----------
      MICROIMAGER         0.0000 
      RAT                 1.5708
      MOSSBAUER           3.3161
      APXS                4.7124

   This diagram illustrates IDD head and instrument frames (looking in the 
   direction of Ztr axis):

                                                     Ztr, Ytrh, Ymi, Yrat
                                                     Ymsb, Yapxs are all 
                                    ^ Zmi                into page.
                                    |
                                    |
                        MicroImager |
                                   .x------>Xmi
               Xapxs              '___` 
                    ^             | ^ Ztrh 
                    |________.    .-|-. 
                    |        |==.'  |  `.       --. RAT
         Zapxs      |        | /    |    \-----'  |
             <------x        | |    x------>   |  |>x------> Zrat
                    |        | \    |    Xtr  -.  | |
                    .________.==`.  |  . Xtrh   --' |
                APXS              `-|-'             |
                                  | V Ytr           V Xrat
                                  |    
                                  |   |
                                  |   | MOSSBAUER
                             <------x-'
                           Xmbs     |
                                    |
                                    |
                                    V Zmsb


   All these frames are defined as fixed offset frames with respect to 
   TURRET_HEAD frame with offsets corresponding to the table below. The
   following sets of keywords should be included into the frame
   definitions to provide this nominal orientation (provided for
   reference only):

      TKFRAME_-253230_AXES             = (   1,      2,       3     )
      TKFRAME_-253230_ANGLES           = (   0.000, -1.5708,  0.000 )

      TKFRAME_-253240_AXES             = (   1,      2,       3     )
      TKFRAME_-253240_ANGLES           = (   0.000, -3.3161,  0.000 )

      TKFRAME_-253210_AXES             = (   1,      2,       3     )
      TKFRAME_-253210_ANGLES           = (   0.000, -4.7124,  0.000 )

      TKFRAME_-253221_AXES             = (   1,      2,       3     )
      TKFRAME_-253221_ANGLES           = (   0.000,  0.0000,  0.000 )

      TKFRAME_-253222_AXES             = (   1,      2,       3     )
      TKFRAME_-253222_ANGLES           = (   0.000,  0.0000,  0.000 )

   \begindata

      FRAME_MER-1_RAT                  = -253230
      FRAME_-253230_NAME               = 'MER-1_RAT'
      FRAME_-253230_CLASS              = 4
      FRAME_-253230_CLASS_ID           = -253230
      FRAME_-253230_CENTER             = -253
      TKFRAME_-253230_RELATIVE         = 'MER-1_IDD_TURRET_HEAD'
      TKFRAME_-253230_SPEC             = 'ANGLES'
      TKFRAME_-253230_UNITS            = 'RADIANS'
      TKFRAME_-253230_AXES             = (   1,      2,       3     )
      TKFRAME_-253230_ANGLES           = (   0.000, -1.5708,  0.000 )

      FRAME_MER-1_MOSSBAUER            = -253240
      FRAME_-253240_NAME               = 'MER-1_MOSSBAUER'
      FRAME_-253240_CLASS              = 4
      FRAME_-253240_CLASS_ID           = -253240
      FRAME_-253240_CENTER             = -253
      TKFRAME_-253240_RELATIVE         = 'MER-1_IDD_TURRET_HEAD'
      TKFRAME_-253240_SPEC             = 'ANGLES'
      TKFRAME_-253240_UNITS            = 'RADIANS'
      TKFRAME_-253240_AXES             = (   1,      2,       3     )
      TKFRAME_-253240_ANGLES           = (   0.000, -3.3161,  0.000 )

      FRAME_MER-1_APXS                 = -253210
      FRAME_-253210_NAME               = 'MER-1_APXS'
      FRAME_-253210_CLASS              = 4
      FRAME_-253210_CLASS_ID           = -253210
      FRAME_-253210_CENTER             = -253
      TKFRAME_-253210_RELATIVE         = 'MER-1_IDD_TURRET_HEAD'
      TKFRAME_-253210_SPEC             = 'ANGLES'
      TKFRAME_-253210_UNITS            = 'RADIANS'
      TKFRAME_-253210_AXES             = (   1,      2,       3     )
      TKFRAME_-253210_ANGLES           = (   0.000, -4.7124,  0.000 )

   \begintext


   The actual MER-1_MICROIMAGER_F1 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_195_SN_110_F_1.cahvor'. According to this model the reference frame,
   MER-1_IDD_TURRET_HEAD, can be transformed into the camera frame,
   MER-1_MICROIMAGER_F1, by the following sequence of rotations: first
   by 0.87833766 degrees about Y, then by -0.34927721 degrees about X, and
   finally by 0.71256786 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_MICROIMAGER_F1       = -253221
      FRAME_-253221_NAME               = 'MER-1_MICROIMAGER_F1'
      FRAME_-253221_CLASS              = 4
      FRAME_-253221_CLASS_ID           = -253221
      FRAME_-253221_CENTER             = -253
      TKFRAME_-253221_RELATIVE         = 'MER-1_IDD_TURRET_HEAD'
      TKFRAME_-253221_SPEC             = 'ANGLES'
      TKFRAME_-253221_UNITS            = 'DEGREES'
      TKFRAME_-253221_AXES             = (    2,        1,        3     )
      TKFRAME_-253221_ANGLES           = (   -0.878,    0.349,   -0.713 )

   \begintext


   The actual MER-1_MICROIMAGER_F2 frame orientation provided in the frame
   definition below was computed using the CAHVOR(E) camera model file,
   'MER_CAL_194_SN_110_F_2.cahvor'. According to this model the reference frame,
   MER-1_IDD_TURRET_HEAD, can be transformed into the camera frame,
   MER-1_MICROIMAGER_F2, by the following sequence of rotations: first
   by 0.87833766 degrees about Y, then by -0.34927721 degrees about X, and
   finally by 0.71256786 degrees about Z.

   The frame definition below contains the opposite of this
   transformation because Euler angles specified in it define
   rotations from the "destination" frame to the "reference" frame.

   \begindata

      FRAME_MER-1_MICROIMAGER_F2       = -253222
      FRAME_-253222_NAME               = 'MER-1_MICROIMAGER_F2'
      FRAME_-253222_CLASS              = 4
      FRAME_-253222_CLASS_ID           = -253222
      FRAME_-253222_CENTER             = -253
      TKFRAME_-253222_RELATIVE         = 'MER-1_IDD_TURRET_HEAD'
      TKFRAME_-253222_SPEC             = 'ANGLES'
      TKFRAME_-253222_UNITS            = 'DEGREES'
      TKFRAME_-253222_AXES             = (    2,        1,        3     )
      TKFRAME_-253222_ANGLES           = (   -0.878,    0.349,   -0.713 )

   \begintext


MER-1 HGA Frames
========================================================================


MER-1 Cruise Antenna Frames
---------------------------

   MER-1 uses three antennas in cruise and EDL -- MGA, Cruise LGA
   (CLGA), and Backshell LGA (BLGA).

   The frame for each of the three antennas is defined as follows:

      *  +Z axis is the antenna boresight direction;

      *  +X axis is the antenna pattern clock angle reference axis;

      *  +Y axis completes the right hand frame;

      *  the origin of this frame is at the center of the antenna plate.

   For all of the antennas, the boresight is cruise or rover -Z, and
   the clock angle reference axis is arbitrary.

   Only one rotation is needed because the clock angle reference axis
   is arbitrary.  A rotation of 180 degrees (or -180 degrees - same
   thing) about the +X axis will co-align the rover frame with the
   antenna frame. This keeps the rover +X axis as the clock reference
   axis. The frame definitions below (which express the same rotation
   for all antennas) implement this orientation.
                                    
   \begindata

      FRAME_MER-1_MGA                  = -253500
      FRAME_-253500_NAME               = 'MER-1_MGA'
      FRAME_-253500_CLASS              = 4
      FRAME_-253500_CLASS_ID           = -253500
      FRAME_-253500_CENTER             = -253
      TKFRAME_-253500_SPEC             = 'ANGLES'
      TKFRAME_-253500_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253500_AXES             = (   1,       2,       3     )
      TKFRAME_-253500_ANGLES           = ( 180.000,   0.000,   0.000 )  
      TKFRAME_-253500_UNITS            = 'DEGREES'

      FRAME_MER-1_CLGA                 = -253510
      FRAME_-253510_NAME               = 'MER-1_CLGA'
      FRAME_-253510_CLASS              = 4
      FRAME_-253510_CLASS_ID           = -253510
      FRAME_-253510_CENTER             = -253
      TKFRAME_-253510_SPEC             = 'ANGLES'
      TKFRAME_-253510_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253510_AXES             = (   1,       2,       3     )
      TKFRAME_-253510_ANGLES           = ( 180.000,   0.000,   0.000 )  
      TKFRAME_-253510_UNITS            = 'DEGREES'

      FRAME_MER-1_BLGA                 = -253520
      FRAME_-253520_NAME               = 'MER-1_BLGA'
      FRAME_-253520_CLASS              = 4
      FRAME_-253520_CLASS_ID           = -253520
      FRAME_-253520_CENTER             = -253
      TKFRAME_-253520_SPEC             = 'ANGLES'
      TKFRAME_-253520_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253520_AXES             = (   1,       2,       3     )
      TKFRAME_-253520_ANGLES           = ( 180.000,   0.000,   0.000 )  
      TKFRAME_-253520_UNITS            = 'DEGREES'

   \begintext


MER-1 UHF Antenna Frame
-----------------------

   MER-1 UHF antenna frame, MER-1_UHF, is defined as follows:

      -- +Z axis is along the antenna boresight, nominally coincident with 
         the rover -Z axis;

      -- +X axis is along the antenna pattern reference axis, nominally 
         coincident with the rover +X axis;

      -- +Y completes the right hand frame;

      -- the origin of this frame is at the geometric center of the antenna
         top surface.

   This diagram illustrates UHF frame:


                                  ^ Zuhf
                                  |
                                  |     /\ PMA
                         HGA      |     \/ 
                          .--.    x------> Xuhf
                         /    \   #Yuhf ||
                        |      |  #     ||
                         \    /=. #     ||
                          `--' || #     ||
                       =======================          
                             |    =o=.    |
                             |  .' Yr `.__|o====o
                           .===o=== o------> Xr \\     
                          .-.      .|.    `.-.  ##o###
                         | o |    | | |   | o |        IDD
                          `-'      `|'     `-'
                                    V Zr


   Since UHF antenna is rigidly mounted on the rover body, its frame is
   defined as fixed offset frame with its orientation given with
   respect to the rover frame.

   Nominally a single rotation of 180 degrees about X is needed to
   align the rover frame with the UHF frame.

   \begindata

      FRAME_MER-1_UHF                  = -253030
      FRAME_-253030_NAME               = 'MER-1_UHF'
      FRAME_-253030_CLASS              = 4
      FRAME_-253030_CLASS_ID           = -253030
      FRAME_-253030_CENTER             = -253
      TKFRAME_-253030_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253030_SPEC             = 'ANGLES'
      TKFRAME_-253030_UNITS            = 'DEGREES'
      TKFRAME_-253030_AXES             = (   3,       2,       1     )
      TKFRAME_-253030_ANGLES           = (   0.000,   0.000, 180.000 )

   \begintext


MER-1 HGA Frames
----------------

   MER-1 HGA base frame is defined as follows:

      -- +Z axis is nominally parallel to the HGA azimuth gimbal rotation
         axis, perpendicular to the rover deck and points "up" (i.e.
         coincident with the rover -Z axis);

      -- +X axis is in the rover deck plane is nominally rotated 30 
         degrees off the rover +X axis toward the rover +Y axis;

      -- +Y axis completes the right hand frame;

      -- the origin of this frame is located at the intersection of the azimuth
         gimbal rotation axis and the rover deck plane.

   This diagram illustrates MER-1 HGA base frame (rover top view):


                               
                   _________ ._. _________
                  /        //   \\        \
                 /        @/ Xr  \@        \
                /        //   ^   \\  Yr    \
               /        //    |    \\        \
              /      Xhgab ^  |     \\        \
             /        //  /   |      \\        \
            . `  <.  //  /    x------>\\   .-' .
           / Yhgab `-.  /   Zr      Yr \\.-' @-' \
          /     `-.   `o                \ ,-'     \
         /        //    Zhgab (out of page)        \
         \       / \_____________________/ \       /
          \     /    __@_____________@__    \     /
           \   /     \                 /     \   /
            \_/       \               /       \_/
                       \             /
                        \___________/
                                            Zr is into the page.

   This frame is fixed with respect to the rover frame, therefore it's 
   defined as a fixed offset frame.

   Nominally two rotations are needed to alight the rover frame with the
   HGA base frame: first by 180 degrees about X, then by -30 degrees
   about Z. The frame definition below implements this orientation

   \begindata

      FRAME_MER-1_HGA_BASE             = -253300
      FRAME_-253300_NAME               = 'MER-1_HGA_BASE'
      FRAME_-253300_CLASS              = 4
      FRAME_-253300_CLASS_ID           = -253300
      FRAME_-253300_CENTER             = -253
      TKFRAME_-253300_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253300_SPEC             = 'ANGLES'
      TKFRAME_-253300_UNITS            = 'DEGREES'
      TKFRAME_-253300_AXES             = (   2,       1,       3     )
      TKFRAME_-253300_ANGLES           = (   0.000, 180.000,  30.000 )

   \begintext

   HGA_ZERO_EL is an auxiliary frame defined to allow storing HGA
   gimbal rotations in separate CK segments. At "zero" AZ angle it is
   co-aligned with the HGA_BASE frame. At any other AZ angle it is
   rotated from the HGA_BASE frame by that angle about Z axis. This
   frame is defined as a CK-based frame.

   \begindata

      FRAME_MER-1_HGA_ZERO_EL          = -253301
      FRAME_-253301_NAME               = 'MER-1_HGA_ZERO_EL'
      FRAME_-253301_CLASS              = 3
      FRAME_-253301_CLASS_ID           = -253301
      FRAME_-253301_CENTER             = -253

      CK_-253301_SCLK                  = -253
      CK_-253301_SPK                   = -253301

   \begintext

   MER-1 HGA frame is defined as follows:

      -- +Z axis is along the HGA boresight;

      -- +X axis is along the HGA elevation gimbal rotation axis and points
         from the HGA dish toward the gimbal;

      -- +Y completes the right hand frame;

      -- the origin of this frame is at the intersection of the HGA boresight
         elevation gimbal rotation axis.

   This diagram illustrates MER-1 HGA frame (HGA assembly back view, zero 
   gimbal position):


                    * * * * *           
                 *             *                      Azimuth
               *                 *                    rotation
              *                   *                    axis
             *                     *        -      _     |
            *                       *      | |----|  `.  |
            *     +Zhga    Xhga     *------| |    |    `.|      Elevation  
            *    (into  x------>    *  ------------------o------ rotation 
            *     page) |           *------| |    |      | `.      axis
            *           |           *      | |----|      |   |
            *           | +Yhga     *       -     .______|___.
             *          V          *                  |  |  |
              *                   *                   |    Zhgab
                *               *                     |  ^  |
                  *           *                 .------- | ---.
                    * * * * *                   |        |    |
                                                |        |    |
            ------------------------------------. <------o  --.-----------
              Rover deck                        Xhgab    Yhgab
                                                      (out of page)


   During normal surface operations the orientation of this frame with
   respect to the HGA base frame varies and is controlled and
   telemetered using HGA azimuth and elevation angles. Therefore, this
   frame is defined as a CK frame with the orientation provided with
   respect to the HGA base frame.

   \begindata

      FRAME_MER-1_HGA                  = -253310
      FRAME_-253310_NAME               = 'MER-1_HGA'
      FRAME_-253310_CLASS              = 3
      FRAME_-253310_CLASS_ID           = -253310
      FRAME_-253310_CENTER             = -253

      CK_-253310_SCLK                  = -253
      CK_-253310_SPK                   = -253310

   \begintext

   In reality the HGA boresight is pointing 0.45 degrees off its
   nominal direction (+Z of HGA frame) towards -X axis of the HGA
   frame. The HGA_BORESIGHT frame, fixed with respect to and rotated by
   the negative of this angle about +Y axis from the HGA frame, has +Z
   axis lined up with the actual boresight.
    
   \begindata

      FRAME_MER-1_HGA_BORESIGHT        = -253311
      FRAME_-253311_NAME               = 'MER-1_HGA_BORESIGHT'
      FRAME_-253311_CLASS              = 4
      FRAME_-253311_CLASS_ID           = -253311
      FRAME_-253311_CENTER             = -253
      TKFRAME_-253311_RELATIVE         = 'MER-1_HGA'
      TKFRAME_-253311_SPEC             = 'ANGLES'
      TKFRAME_-253311_UNITS            = 'DEGREES'
      TKFRAME_-253311_AXES             = (   2,      1,      3     )
      TKFRAME_-253311_ANGLES           = (   0.45,   0.000,  0.000 )

   \begintext


MER-1 Rover LGA Frame
---------------------

   The MER-1 rover LGA is defined as follows:

      *  +Z axis is the antenna boresight direction;

      *  +X axis is the antenna pattern clock angle reference axis;

      *  +Y axis completes the right hand frame;

      *  the origin of this frame is at the center of the antenna plate.

   As for the other antennas, the boresight is rover -Z, and the clock
   angle reference axis is arbitrary.

   Only one rotation is needed because the clock angle reference axis
   is arbitrary.  A rotation of 180 degrees (or -180 degrees - same
   thing) about the +X axis will co-align the rover frame with the
   antenna frame. This keeps the rover +X axis as the clock reference
   axis. The frame definitions below (which express the same rotation
   for all antennas) implement this orientation.
                                    
   \begindata

      FRAME_MER-1_RLGA                 = -253540
      FRAME_-253540_NAME               = 'MER-1_RLGA'
      FRAME_-253540_CLASS              = 4
      FRAME_-253540_CLASS_ID           = -253540
      FRAME_-253540_CENTER             = -253
      TKFRAME_-253540_SPEC             = 'ANGLES'
      TKFRAME_-253540_RELATIVE         = 'MER-1_ROVER'
      TKFRAME_-253540_AXES             = (   1,       2,       3     )
      TKFRAME_-253540_ANGLES           = ( 180.000,   0.000,   0.000 )  
      TKFRAME_-253540_UNITS            = 'DEGREES'

   \begintext


MER-1 Mobility System Frames
========================================================================

   This diagram illustrates the MAS frames:

      <<TBD>>


MER-1 Mobility System Frames
----------------------------

   All MER-1 MAS frames are CK-based frames as their orientation changes 
   constantly as the rover moves along.

   Description of the MAS frame are <<TBD>>.

   \begindata

      FRAME_MER-1_ROCKER_LEFT          = -253410
      FRAME_-253410_NAME               = 'MER-1_ROCKER_LEFT'
      FRAME_-253410_CLASS              = 3
      FRAME_-253410_CLASS_ID           = -253410
      FRAME_-253410_CENTER             = -253
      CK_-253410_SCLK                  = -253
      CK_-253410_SPK                   = -253410

      FRAME_MER-1_BOGEY_LEFT           = -253411
      FRAME_-253411_NAME               = 'MER-1_BOGEY_LEFT'
      FRAME_-253411_CLASS              = 3
      FRAME_-253411_CLASS_ID           = -253411
      FRAME_-253411_CENTER             = -253
      CK_-253411_SCLK                  = -253
      CK_-253411_SPK                   = -253411

      FRAME_MER-1_STRUT_FRONT_LEFT     = -253412
      FRAME_-253412_NAME               = 'MER-1_STRUT_FRONT_LEFT'
      FRAME_-253412_CLASS              = 3
      FRAME_-253412_CLASS_ID           = -253412
      FRAME_-253412_CENTER             = -253
      CK_-253412_SCLK                  = -253
      CK_-253412_SPK                   = -253412

      FRAME_MER-1_STRUT_REAR_LEFT      = -253413
      FRAME_-253413_NAME               = 'MER-1_STRUT_REAR_LEFT'
      FRAME_-253413_CLASS              = 3
      FRAME_-253413_CLASS_ID           = -253413
      FRAME_-253413_CENTER             = -253
      CK_-253413_SCLK                  = -253
      CK_-253413_SPK                   = -253413

      FRAME_MER-1_ROCKER_RIGHT         = -253420
      FRAME_-253420_NAME               = 'MER-1_ROCKER_RIGHT'
      FRAME_-253420_CLASS              = 3
      FRAME_-253420_CLASS_ID           = -253420
      FRAME_-253420_CENTER             = -253
      CK_-253420_SCLK                  = -253
      CK_-253420_SPK                   = -253420

      FRAME_MER-1_BOGEY_RIGHT          = -253421
      FRAME_-253421_NAME               = 'MER-1_BOGEY_RIGHT'
      FRAME_-253421_CLASS              = 3
      FRAME_-253421_CLASS_ID           = -253421
      FRAME_-253421_CENTER             = -253
      CK_-253421_SCLK                  = -253
      CK_-253421_SPK                   = -253421

      FRAME_MER-1_STRUT_FRONT_RIGHT    = -253422
      FRAME_-253422_NAME               = 'MER-1_STRUT_FRONT_RIGHT'
      FRAME_-253422_CLASS              = 3
      FRAME_-253422_CLASS_ID           = -253422
      FRAME_-253422_CENTER             = -253
      CK_-253422_SCLK                  = -253
      CK_-253422_SPK                   = -253422

      FRAME_MER-1_STRUT_REAR_RIGHT     = -253423
      FRAME_-253423_NAME               = 'MER-1_STRUT_REAR_RIGHT'
      FRAME_-253423_CLASS              = 3
      FRAME_-253423_CLASS_ID           = -253423
      FRAME_-253423_CENTER             = -253
      CK_-253423_SCLK                  = -253
      CK_-253423_SPK                   = -253423

   \begintext


MER-1 NAIF ID Codes -- Definition Section
========================================================================

   This section contains name to NAIF ID mappings for the MER-1.


MER-1 rover and landing site names and IDs
------------------------------------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1'                    )
      NAIF_BODY_CODE += ( -253                       )

      NAIF_BODY_NAME += ( 'MER-1_LANDING_SITE'       )
      NAIF_BODY_CODE += ( -253900                    )


   \begintext


MER-1 rover body-mounted instruments names and IDs
----------------------------------------------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1_FRONT_HAZCAM_LEFT'  )
      NAIF_BODY_CODE += ( -253011                    )

      NAIF_BODY_NAME += ( 'MER-1_FRONT_HAZCAM_RIGHT' )
      NAIF_BODY_CODE += ( -253012                    )

      NAIF_BODY_NAME += ( 'MER-1_REAR_HAZCAM_LEFT'   )
      NAIF_BODY_CODE += ( -253021                    )

      NAIF_BODY_NAME += ( 'MER-1_REAR_HAZCAM_RIGHT'  )
      NAIF_BODY_CODE += ( -253022                    )

   \begintext


MER-1 PMA structures and PMA-mounted instrument names and IDs
---------------------------------------------------------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1_PMA_BASE'           )
      NAIF_BODY_CODE += ( -253100                    )

      NAIF_BODY_NAME += ( 'MER-1_PMA_HEAD'           )
      NAIF_BODY_CODE += ( -253110                    )

      NAIF_BODY_NAME += ( 'MER-1_NAVCAM_LEFT'        )
      NAIF_BODY_CODE += ( -253111                    )

      NAIF_BODY_NAME += ( 'MER-1_NAVCAM_RIGHT'       )
      NAIF_BODY_CODE += ( -253112                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F1'     )
      NAIF_BODY_CODE += ( -253121                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F2'     )
      NAIF_BODY_CODE += ( -253122                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F3'     )
      NAIF_BODY_CODE += ( -253123                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F4'     )
      NAIF_BODY_CODE += ( -253124                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F5'     )
      NAIF_BODY_CODE += ( -253125                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F6'     )
      NAIF_BODY_CODE += ( -253126                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F7'     )
      NAIF_BODY_CODE += ( -253127                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_LEFT_F8'     )
      NAIF_BODY_CODE += ( -253128                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F1'    )
      NAIF_BODY_CODE += ( -253131                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F2'    )
      NAIF_BODY_CODE += ( -253132                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F3'    )
      NAIF_BODY_CODE += ( -253133                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F4'    )
      NAIF_BODY_CODE += ( -253134                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F5'    )
      NAIF_BODY_CODE += ( -253135                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F6'    )
      NAIF_BODY_CODE += ( -253136                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F7'    )
      NAIF_BODY_CODE += ( -253137                    )

      NAIF_BODY_NAME += ( 'MER-1_PANCAM_RIGHT_F8'    )
      NAIF_BODY_CODE += ( -253138                    )

      NAIF_BODY_NAME += ( 'MER-1_MINITES'            )
      NAIF_BODY_CODE += ( -253140                    )


   \begintext


MER-1 IDD structures and IDD-mounted instrument names and IDs
---------------------------------------------------------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1_IDD_BASE'           )
      NAIF_BODY_CODE += ( -253200                    )

      NAIF_BODY_NAME += ( 'MER-1_IDD_SHOULDER_AZ'    )
      NAIF_BODY_CODE += ( -253201                    )

      NAIF_BODY_NAME += ( 'MER-1_IDD_SHOULDER_EL'    )
      NAIF_BODY_CODE += ( -253202                    )

      NAIF_BODY_NAME += ( 'MER-1_IDD_ELBOW'          )
      NAIF_BODY_CODE += ( -253203                    )

      NAIF_BODY_NAME += ( 'MER-1_IDD_WRIST'          )
      NAIF_BODY_CODE += ( -253204                    )

      NAIF_BODY_NAME += ( 'MER-1_IDD_TURRET'         )
      NAIF_BODY_CODE += ( -253205                    )

      NAIF_BODY_NAME += ( 'MER-1_IDD_TURRET_HEAD'    )
      NAIF_BODY_CODE += ( -253206                    )

      NAIF_BODY_NAME += ( 'MER-1_APXS'               )
      NAIF_BODY_CODE += ( -253210                    )

      NAIF_BODY_NAME += ( 'MER-1_MICROIMAGER'        )
      NAIF_BODY_CODE += ( -253220                    )

      NAIF_BODY_NAME += ( 'MER-1_MICROIMAGER_F1'     )
      NAIF_BODY_CODE += ( -253221                    )

      NAIF_BODY_NAME += ( 'MER-1_MICROIMAGER_F2'     )
      NAIF_BODY_CODE += ( -253222                    )

      NAIF_BODY_NAME += ( 'MER-1_RAT'                )
      NAIF_BODY_CODE += ( -253230                    )
  
      NAIF_BODY_NAME += ( 'MER-1_MOSSBAUER'          )
      NAIF_BODY_CODE += ( -253240                    )

   \begintext


MER-1 antenna names and IDs
---------------------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1_MGA'                )
      NAIF_BODY_CODE += ( -253500                    )

      NAIF_BODY_NAME += ( 'MER-1_CLGA'               )
      NAIF_BODY_CODE += ( -253510                    )

      NAIF_BODY_NAME += ( 'MER-1_BLGA'               )
      NAIF_BODY_CODE += ( -253520                    )

      NAIF_BODY_NAME += ( 'MER-1_UHF'                )
      NAIF_BODY_CODE += ( -253030                    )

      NAIF_BODY_NAME += ( 'MER-1_HGA_BASE'           )
      NAIF_BODY_CODE += ( -253300                    )

      NAIF_BODY_NAME += ( 'MER-1_HGA'                )
      NAIF_BODY_CODE += ( -253310                    )

      NAIF_BODY_NAME += ( 'MER-1_RLGA'               )
      NAIF_BODY_CODE += ( -253540                    )

   \begintext


MER-1 mobility system components names and IDs
----------------------------------------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1_ROCKER_LEFT'        )
      NAIF_BODY_CODE += ( -253410                    )

      NAIF_BODY_NAME += ( 'MER-1_BOGEY_LEFT'         )
      NAIF_BODY_CODE += ( -253411                    )

      NAIF_BODY_NAME += ( 'MER-1_STRUT_FRONT_LEFT'   )
      NAIF_BODY_CODE += ( -253412                    )

      NAIF_BODY_NAME += ( 'MER-1_STRUT_REAR_LEFT'    )
      NAIF_BODY_CODE += ( -253413                    )

      NAIF_BODY_NAME += ( 'MER-1_ROCKER_RIGHT'       )
      NAIF_BODY_CODE += ( -253420                    ) 

      NAIF_BODY_NAME += ( 'MER-1_BOGEY_RIGHT'        )
      NAIF_BODY_CODE += ( -253421                    )

      NAIF_BODY_NAME += ( 'MER-1_STRUT_FRONT_RIGHT'  )
      NAIF_BODY_CODE += ( -253422                    )

      NAIF_BODY_NAME += ( 'MER-1_STRUT_REAR_RIGHT'   )
      NAIF_BODY_CODE += ( -253423                    )

   \begintext


MER-1 Site IDs
--------------

   \begindata

      NAIF_BODY_NAME += ( 'MER-1_SITE_1'             )
      NAIF_BODY_CODE += ( -253901                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_2'             )
      NAIF_BODY_CODE += ( -253902                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_3'             )
      NAIF_BODY_CODE += ( -253903                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_4'             )
      NAIF_BODY_CODE += ( -253904                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_5'             )
      NAIF_BODY_CODE += ( -253905                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_6'             )
      NAIF_BODY_CODE += ( -253906                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_7'             )
      NAIF_BODY_CODE += ( -253907                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_8'             )
      NAIF_BODY_CODE += ( -253908                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_9'             )
      NAIF_BODY_CODE += ( -253909                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_10'            )
      NAIF_BODY_CODE += ( -253910                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_11'            )
      NAIF_BODY_CODE += ( -253911                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_12'            )
      NAIF_BODY_CODE += ( -253912                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_13'            )
      NAIF_BODY_CODE += ( -253913                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_14'            )
      NAIF_BODY_CODE += ( -253914                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_15'            )
      NAIF_BODY_CODE += ( -253915                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_16'            )
      NAIF_BODY_CODE += ( -253916                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_17'            )
      NAIF_BODY_CODE += ( -253917                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_18'            )
      NAIF_BODY_CODE += ( -253918                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_19'            )
      NAIF_BODY_CODE += ( -253919                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_20'            )
      NAIF_BODY_CODE += ( -253920                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_21'            )
      NAIF_BODY_CODE += ( -253921                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_22'            )
      NAIF_BODY_CODE += ( -253922                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_23'            )
      NAIF_BODY_CODE += ( -253923                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_24'            )
      NAIF_BODY_CODE += ( -253924                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_25'            )
      NAIF_BODY_CODE += ( -253925                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_26'            )
      NAIF_BODY_CODE += ( -253926                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_27'            )
      NAIF_BODY_CODE += ( -253927                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_28'            )
      NAIF_BODY_CODE += ( -253928                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_29'            )
      NAIF_BODY_CODE += ( -253929                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_30'            )
      NAIF_BODY_CODE += ( -253930                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_31'            )
      NAIF_BODY_CODE += ( -253931                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_32'            )
      NAIF_BODY_CODE += ( -253932                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_33'            )
      NAIF_BODY_CODE += ( -253933                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_34'            )
      NAIF_BODY_CODE += ( -253934                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_35'            )
      NAIF_BODY_CODE += ( -253935                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_36'            )
      NAIF_BODY_CODE += ( -253936                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_37'            )
      NAIF_BODY_CODE += ( -253937                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_38'            )
      NAIF_BODY_CODE += ( -253938                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_39'            )
      NAIF_BODY_CODE += ( -253939                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_40'            )
      NAIF_BODY_CODE += ( -253940                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_41'            )
      NAIF_BODY_CODE += ( -253941                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_42'            )
      NAIF_BODY_CODE += ( -253942                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_43'            )
      NAIF_BODY_CODE += ( -253943                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_44'            )
      NAIF_BODY_CODE += ( -253944                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_45'            )
      NAIF_BODY_CODE += ( -253945                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_46'            )
      NAIF_BODY_CODE += ( -253946                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_47'            )
      NAIF_BODY_CODE += ( -253947                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_48'            )
      NAIF_BODY_CODE += ( -253948                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_49'            )
      NAIF_BODY_CODE += ( -253949                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_50'            )
      NAIF_BODY_CODE += ( -253950                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_51'            )
      NAIF_BODY_CODE += ( -253951                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_52'            )
      NAIF_BODY_CODE += ( -253952                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_53'            )
      NAIF_BODY_CODE += ( -253953                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_54'            )
      NAIF_BODY_CODE += ( -253954                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_55'            )
      NAIF_BODY_CODE += ( -253955                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_56'            )
      NAIF_BODY_CODE += ( -253956                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_57'            )
      NAIF_BODY_CODE += ( -253957                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_58'            )
      NAIF_BODY_CODE += ( -253958                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_59'            )
      NAIF_BODY_CODE += ( -253959                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_60'            )
      NAIF_BODY_CODE += ( -253960                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_61'            )
      NAIF_BODY_CODE += ( -253961                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_62'            )
      NAIF_BODY_CODE += ( -253962                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_63'            )
      NAIF_BODY_CODE += ( -253963                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_64'            )
      NAIF_BODY_CODE += ( -253964                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_65'            )
      NAIF_BODY_CODE += ( -253965                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_66'            )
      NAIF_BODY_CODE += ( -253966                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_67'            )
      NAIF_BODY_CODE += ( -253967                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_68'            )
      NAIF_BODY_CODE += ( -253968                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_69'            )
      NAIF_BODY_CODE += ( -253969                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_70'            )
      NAIF_BODY_CODE += ( -253970                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_71'            )
      NAIF_BODY_CODE += ( -253971                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_72'            )
      NAIF_BODY_CODE += ( -253972                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_73'            )
      NAIF_BODY_CODE += ( -253973                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_74'            )
      NAIF_BODY_CODE += ( -253974                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_75'            )
      NAIF_BODY_CODE += ( -253975                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_76'            )
      NAIF_BODY_CODE += ( -253976                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_77'            )
      NAIF_BODY_CODE += ( -253977                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_78'            )
      NAIF_BODY_CODE += ( -253978                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_79'            )
      NAIF_BODY_CODE += ( -253979                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_80'            )
      NAIF_BODY_CODE += ( -253980                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_81'            )
      NAIF_BODY_CODE += ( -253981                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_82'            )
      NAIF_BODY_CODE += ( -253982                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_83'            )
      NAIF_BODY_CODE += ( -253983                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_84'            )
      NAIF_BODY_CODE += ( -253984                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_85'            )
      NAIF_BODY_CODE += ( -253985                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_86'            )
      NAIF_BODY_CODE += ( -253986                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_87'            )
      NAIF_BODY_CODE += ( -253987                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_88'            )
      NAIF_BODY_CODE += ( -253988                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_89'            )
      NAIF_BODY_CODE += ( -253989                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_90'            )
      NAIF_BODY_CODE += ( -253990                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_91'            )
      NAIF_BODY_CODE += ( -253991                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_92'            )
      NAIF_BODY_CODE += ( -253992                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_93'            )
      NAIF_BODY_CODE += ( -253993                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_94'            )
      NAIF_BODY_CODE += ( -253994                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_95'            )
      NAIF_BODY_CODE += ( -253995                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_96'            )
      NAIF_BODY_CODE += ( -253996                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_97'            )
      NAIF_BODY_CODE += ( -253997                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_98'            )
      NAIF_BODY_CODE += ( -253998                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_99'            )
      NAIF_BODY_CODE += ( -253999                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_100'           )
      NAIF_BODY_CODE += ( -253800                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_101'           )
      NAIF_BODY_CODE += ( -253801                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_102'           )
      NAIF_BODY_CODE += ( -253802                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_103'           )
      NAIF_BODY_CODE += ( -253803                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_104'           )
      NAIF_BODY_CODE += ( -253804                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_105'           )
      NAIF_BODY_CODE += ( -253805                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_106'           )
      NAIF_BODY_CODE += ( -253806                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_107'           )
      NAIF_BODY_CODE += ( -253807                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_108'           )
      NAIF_BODY_CODE += ( -253808                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_109'           )
      NAIF_BODY_CODE += ( -253809                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_110'           )
      NAIF_BODY_CODE += ( -253810                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_111'           )
      NAIF_BODY_CODE += ( -253811                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_112'           )
      NAIF_BODY_CODE += ( -253812                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_113'           )
      NAIF_BODY_CODE += ( -253813                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_114'           )
      NAIF_BODY_CODE += ( -253814                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_115'           )
      NAIF_BODY_CODE += ( -253815                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_116'           )
      NAIF_BODY_CODE += ( -253816                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_117'           )
      NAIF_BODY_CODE += ( -253817                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_118'           )
      NAIF_BODY_CODE += ( -253818                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_119'           )
      NAIF_BODY_CODE += ( -253819                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_120'           )
      NAIF_BODY_CODE += ( -253820                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_121'           )
      NAIF_BODY_CODE += ( -253821                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_122'           )
      NAIF_BODY_CODE += ( -253822                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_123'           )
      NAIF_BODY_CODE += ( -253823                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_124'           )
      NAIF_BODY_CODE += ( -253824                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_125'           )
      NAIF_BODY_CODE += ( -253825                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_126'           )
      NAIF_BODY_CODE += ( -253826                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_127'           )
      NAIF_BODY_CODE += ( -253827                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_128'           )
      NAIF_BODY_CODE += ( -253828                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_129'           )
      NAIF_BODY_CODE += ( -253829                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_130'           )
      NAIF_BODY_CODE += ( -253830                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_131'           )
      NAIF_BODY_CODE += ( -253831                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_132'           )
      NAIF_BODY_CODE += ( -253832                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_133'           )
      NAIF_BODY_CODE += ( -253833                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_134'           )
      NAIF_BODY_CODE += ( -253834                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_135'           )
      NAIF_BODY_CODE += ( -253835                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_136'           )
      NAIF_BODY_CODE += ( -253836                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_137'           )
      NAIF_BODY_CODE += ( -253837                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_138'           )
      NAIF_BODY_CODE += ( -253838                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_139'           )
      NAIF_BODY_CODE += ( -253839                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_140'           )
      NAIF_BODY_CODE += ( -253840                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_141'           )
      NAIF_BODY_CODE += ( -253841                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_142'           )
      NAIF_BODY_CODE += ( -253842                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_143'           )
      NAIF_BODY_CODE += ( -253843                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_144'           )
      NAIF_BODY_CODE += ( -253844                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_145'           )
      NAIF_BODY_CODE += ( -253845                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_146'           )
      NAIF_BODY_CODE += ( -253846                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_147'           )
      NAIF_BODY_CODE += ( -253847                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_148'           )
      NAIF_BODY_CODE += ( -253848                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_149'           )
      NAIF_BODY_CODE += ( -253849                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_150'           )
      NAIF_BODY_CODE += ( -253850                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_151'           )
      NAIF_BODY_CODE += ( -253851                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_152'           )
      NAIF_BODY_CODE += ( -253852                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_153'           )
      NAIF_BODY_CODE += ( -253853                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_154'           )
      NAIF_BODY_CODE += ( -253854                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_155'           )
      NAIF_BODY_CODE += ( -253855                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_156'           )
      NAIF_BODY_CODE += ( -253856                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_157'           )
      NAIF_BODY_CODE += ( -253857                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_158'           )
      NAIF_BODY_CODE += ( -253858                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_159'           )
      NAIF_BODY_CODE += ( -253859                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_160'           )
      NAIF_BODY_CODE += ( -253860                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_161'           )
      NAIF_BODY_CODE += ( -253861                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_162'           )
      NAIF_BODY_CODE += ( -253862                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_163'           )
      NAIF_BODY_CODE += ( -253863                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_164'           )
      NAIF_BODY_CODE += ( -253864                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_165'           )
      NAIF_BODY_CODE += ( -253865                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_166'           )
      NAIF_BODY_CODE += ( -253866                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_167'           )
      NAIF_BODY_CODE += ( -253867                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_168'           )
      NAIF_BODY_CODE += ( -253868                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_169'           )
      NAIF_BODY_CODE += ( -253869                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_170'           )
      NAIF_BODY_CODE += ( -253870                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_171'           )
      NAIF_BODY_CODE += ( -253871                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_172'           )
      NAIF_BODY_CODE += ( -253872                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_173'           )
      NAIF_BODY_CODE += ( -253873                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_174'           )
      NAIF_BODY_CODE += ( -253874                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_175'           )
      NAIF_BODY_CODE += ( -253875                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_176'           )
      NAIF_BODY_CODE += ( -253876                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_177'           )
      NAIF_BODY_CODE += ( -253877                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_178'           )
      NAIF_BODY_CODE += ( -253878                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_179'           )
      NAIF_BODY_CODE += ( -253879                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_180'           )
      NAIF_BODY_CODE += ( -253880                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_181'           )
      NAIF_BODY_CODE += ( -253881                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_182'           )
      NAIF_BODY_CODE += ( -253882                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_183'           )
      NAIF_BODY_CODE += ( -253883                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_184'           )
      NAIF_BODY_CODE += ( -253884                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_185'           )
      NAIF_BODY_CODE += ( -253885                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_186'           )
      NAIF_BODY_CODE += ( -253886                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_187'           )
      NAIF_BODY_CODE += ( -253887                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_188'           )
      NAIF_BODY_CODE += ( -253888                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_189'           )
      NAIF_BODY_CODE += ( -253889                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_190'           )
      NAIF_BODY_CODE += ( -253890                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_191'           )
      NAIF_BODY_CODE += ( -253891                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_192'           )
      NAIF_BODY_CODE += ( -253892                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_193'           )
      NAIF_BODY_CODE += ( -253893                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_194'           )
      NAIF_BODY_CODE += ( -253894                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_195'           )
      NAIF_BODY_CODE += ( -253895                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_196'           )
      NAIF_BODY_CODE += ( -253896                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_197'           )
      NAIF_BODY_CODE += ( -253897                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_198'           )
      NAIF_BODY_CODE += ( -253898                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_199'           )
      NAIF_BODY_CODE += ( -253899                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_200'           )
      NAIF_BODY_CODE += ( -253700                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_201'           )
      NAIF_BODY_CODE += ( -253701                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_202'           )
      NAIF_BODY_CODE += ( -253702                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_203'           )
      NAIF_BODY_CODE += ( -253703                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_204'           )
      NAIF_BODY_CODE += ( -253704                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_205'           )
      NAIF_BODY_CODE += ( -253705                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_206'           )
      NAIF_BODY_CODE += ( -253706                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_207'           )
      NAIF_BODY_CODE += ( -253707                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_208'           )
      NAIF_BODY_CODE += ( -253708                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_209'           )
      NAIF_BODY_CODE += ( -253709                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_210'           )
      NAIF_BODY_CODE += ( -253710                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_211'           )
      NAIF_BODY_CODE += ( -253711                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_212'           )
      NAIF_BODY_CODE += ( -253712                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_213'           )
      NAIF_BODY_CODE += ( -253713                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_214'           )
      NAIF_BODY_CODE += ( -253714                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_215'           )
      NAIF_BODY_CODE += ( -253715                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_216'           )
      NAIF_BODY_CODE += ( -253716                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_217'           )
      NAIF_BODY_CODE += ( -253717                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_218'           )
      NAIF_BODY_CODE += ( -253718                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_219'           )
      NAIF_BODY_CODE += ( -253719                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_220'           )
      NAIF_BODY_CODE += ( -253720                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_221'           )
      NAIF_BODY_CODE += ( -253721                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_222'           )
      NAIF_BODY_CODE += ( -253722                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_223'           )
      NAIF_BODY_CODE += ( -253723                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_224'           )
      NAIF_BODY_CODE += ( -253724                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_225'           )
      NAIF_BODY_CODE += ( -253725                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_226'           )
      NAIF_BODY_CODE += ( -253726                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_227'           )
      NAIF_BODY_CODE += ( -253727                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_228'           )
      NAIF_BODY_CODE += ( -253728                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_229'           )
      NAIF_BODY_CODE += ( -253729                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_230'           )
      NAIF_BODY_CODE += ( -253730                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_231'           )
      NAIF_BODY_CODE += ( -253731                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_232'           )
      NAIF_BODY_CODE += ( -253732                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_233'           )
      NAIF_BODY_CODE += ( -253733                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_234'           )
      NAIF_BODY_CODE += ( -253734                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_235'           )
      NAIF_BODY_CODE += ( -253735                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_236'           )
      NAIF_BODY_CODE += ( -253736                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_237'           )
      NAIF_BODY_CODE += ( -253737                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_238'           )
      NAIF_BODY_CODE += ( -253738                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_239'           )
      NAIF_BODY_CODE += ( -253739                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_240'           )
      NAIF_BODY_CODE += ( -253740                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_241'           )
      NAIF_BODY_CODE += ( -253741                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_242'           )
      NAIF_BODY_CODE += ( -253742                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_243'           )
      NAIF_BODY_CODE += ( -253743                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_244'           )
      NAIF_BODY_CODE += ( -253744                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_245'           )
      NAIF_BODY_CODE += ( -253745                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_246'           )
      NAIF_BODY_CODE += ( -253746                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_247'           )
      NAIF_BODY_CODE += ( -253747                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_248'           )
      NAIF_BODY_CODE += ( -253748                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_249'           )
      NAIF_BODY_CODE += ( -253749                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_250'           )
      NAIF_BODY_CODE += ( -253750                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_251'           )
      NAIF_BODY_CODE += ( -253751                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_252'           )
      NAIF_BODY_CODE += ( -253752                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_253'           )
      NAIF_BODY_CODE += ( -253753                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_254'           )
      NAIF_BODY_CODE += ( -253754                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_255'           )
      NAIF_BODY_CODE += ( -253755                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_256'           )
      NAIF_BODY_CODE += ( -253756                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_257'           )
      NAIF_BODY_CODE += ( -253757                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_258'           )
      NAIF_BODY_CODE += ( -253758                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_259'           )
      NAIF_BODY_CODE += ( -253759                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_260'           )
      NAIF_BODY_CODE += ( -253760                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_261'           )
      NAIF_BODY_CODE += ( -253761                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_262'           )
      NAIF_BODY_CODE += ( -253762                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_263'           )
      NAIF_BODY_CODE += ( -253763                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_264'           )
      NAIF_BODY_CODE += ( -253764                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_265'           )
      NAIF_BODY_CODE += ( -253765                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_266'           )
      NAIF_BODY_CODE += ( -253766                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_267'           )
      NAIF_BODY_CODE += ( -253767                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_268'           )
      NAIF_BODY_CODE += ( -253768                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_269'           )
      NAIF_BODY_CODE += ( -253769                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_270'           )
      NAIF_BODY_CODE += ( -253770                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_271'           )
      NAIF_BODY_CODE += ( -253771                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_272'           )
      NAIF_BODY_CODE += ( -253772                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_273'           )
      NAIF_BODY_CODE += ( -253773                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_274'           )
      NAIF_BODY_CODE += ( -253774                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_275'           )
      NAIF_BODY_CODE += ( -253775                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_276'           )
      NAIF_BODY_CODE += ( -253776                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_277'           )
      NAIF_BODY_CODE += ( -253777                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_278'           )
      NAIF_BODY_CODE += ( -253778                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_279'           )
      NAIF_BODY_CODE += ( -253779                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_280'           )
      NAIF_BODY_CODE += ( -253780                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_281'           )
      NAIF_BODY_CODE += ( -253781                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_282'           )
      NAIF_BODY_CODE += ( -253782                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_283'           )
      NAIF_BODY_CODE += ( -253783                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_284'           )
      NAIF_BODY_CODE += ( -253784                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_285'           )
      NAIF_BODY_CODE += ( -253785                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_286'           )
      NAIF_BODY_CODE += ( -253786                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_287'           )
      NAIF_BODY_CODE += ( -253787                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_288'           )
      NAIF_BODY_CODE += ( -253788                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_289'           )
      NAIF_BODY_CODE += ( -253789                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_290'           )
      NAIF_BODY_CODE += ( -253790                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_291'           )
      NAIF_BODY_CODE += ( -253791                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_292'           )
      NAIF_BODY_CODE += ( -253792                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_293'           )
      NAIF_BODY_CODE += ( -253793                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_294'           )
      NAIF_BODY_CODE += ( -253794                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_295'           )
      NAIF_BODY_CODE += ( -253795                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_296'           )
      NAIF_BODY_CODE += ( -253796                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_297'           )
      NAIF_BODY_CODE += ( -253797                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_298'           )
      NAIF_BODY_CODE += ( -253798                    )


      NAIF_BODY_NAME += ( 'MER-1_SITE_299'           )
      NAIF_BODY_CODE += ( -253799                    )

   \begintext

End of FK.


